/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.jdcloud.service;

import cn.hutool.core.util.IdUtil;
import com.jdcloud.sdk.service.sms.client.SmsClient;
import com.jdcloud.sdk.service.sms.model.BatchSendRequest;
import com.jdcloud.sdk.service.sms.model.BatchSendResult;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.jdcloud.config.JdCloudConfig;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdCloudSmsImpl
extends AbstractSmsBlend<JdCloudConfig> {
    private static final Logger log = LoggerFactory.getLogger(JdCloudSmsImpl.class);
    private final SmsClient client;
    private int retry = 0;

    public JdCloudSmsImpl(SmsClient client, JdCloudConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
        this.client = client;
    }

    public JdCloudSmsImpl(SmsClient client, JdCloudConfig config) {
        super(config);
        this.client = client;
    }

    public String getSupplier() {
        return "jdcloud";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        return this.massTexting(Collections.singletonList(phone), message);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((JdCloudConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.massTexting(Collections.singletonList(phone), templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(IdUtil.fastSimpleUUID(), message);
        return this.massTexting(phones, ((JdCloudConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        SmsResponse smsResponse;
        BatchSendRequest request;
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        try {
            request = new BatchSendRequest();
            request.setPhoneList(phones);
            request.setRegionId(((JdCloudConfig)this.getConfig()).getRegion());
            request.setTemplateId(templateId);
            request.setSignId(((JdCloudConfig)this.getConfig()).getSignature());
            List params = messages.keySet().stream().map(messages::get).collect(Collectors.toList());
            request.setParams(params);
        }
        catch (Exception e) {
            throw new SmsBlendException(e.getMessage());
        }
        BatchSendResult result = (BatchSendResult)this.client.batchSend(request).getResult();
        try {
            smsResponse = this.getSmsResponse(result);
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry >= ((JdCloudConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phones, templateId, messages);
    }

    private SmsResponse requestRetry(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        this.http.safeSleep(((JdCloudConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.massTexting(phones, templateId, messages);
    }

    private SmsResponse getSmsResponse(BatchSendResult res) {
        return SmsRespUtils.resp((Object)res, (res.getStatus() != null && res.getStatus() != false ? 1 : 0) != 0, (String)this.getConfigId());
    }
}

