/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqltranslator.jooq;

import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqltranslator.exception.SQLTranslationException;
import org.apache.shardingsphere.sqltranslator.exception.UnsupportedTranslatedSQLException;
import org.apache.shardingsphere.sqltranslator.jooq.JooQDialectRegistry;
import org.apache.shardingsphere.sqltranslator.spi.SQLTranslator;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;

public final class JooQSQLTranslator
implements SQLTranslator {
    public String translate(String sql, SQLStatement statement, DatabaseType protocolType, DatabaseType storageType) throws SQLTranslationException {
        try {
            Query query = DSL.using((SQLDialect)JooQDialectRegistry.getSQLDialect(protocolType)).parser().parseQuery(sql);
            return DSL.using((SQLDialect)JooQDialectRegistry.getSQLDialect(storageType)).render((QueryPart)query);
        }
        catch (Exception ex) {
            throw new UnsupportedTranslatedSQLException(sql, ex);
        }
    }

    public String getType() {
        return "JOOQ";
    }

    public boolean isDefault() {
        return true;
    }
}

