/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.original.table;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.dialect.MssqlSqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.OracleSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RelBuilder;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.type.dialect.H2DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MariaDBDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OracleDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.SQLServerDatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.original.row.EmptyRowEnumerator;
import org.apache.shardingsphere.infra.federation.executor.original.row.FilterableRowEnumerator;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanContext;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationTableMetaData;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class FilterableTableScanExecutor {
    private static final Map<Class<? extends DatabaseType>, SqlDialect> SQL_DIALECTS = new HashMap<Class<? extends DatabaseType>, SqlDialect>();
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final OptimizerContext optimizerContext;
    private final FilterableTableScanExecutorContext executorContext;

    public FilterableTableScanExecutor(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutor jdbcExecutor, JDBCExecutorCallback<? extends ExecuteResult> callback, OptimizerContext optimizerContext, FilterableTableScanExecutorContext executorContext) {
        this.jdbcExecutor = jdbcExecutor;
        this.callback = callback;
        this.prepareEngine = prepareEngine;
        this.optimizerContext = optimizerContext;
        this.executorContext = executorContext;
    }

    public Enumerable<Object[]> execute(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName();
        String schemaName = this.executorContext.getSchemaName();
        DatabaseType databaseType = DatabaseTypeEngine.getTrunkDatabaseType((String)((OptimizerParserContext)this.optimizerContext.getParserContexts().get(databaseName)).getDatabaseType().getType());
        SqlString sqlString = this.createSQLString(tableMetaData, scanContext, databaseType);
        FederationContext federationContext = this.executorContext.getFederationContext();
        LogicSQL logicSQL = this.createLogicSQL(federationContext.getDatabases(), sqlString, databaseType);
        ShardingSphereDatabase database = federationContext.getDatabases().get(databaseName);
        ExecutionContext context = new KernelProcessor().generateExecutionContext(logicSQL, database, this.executorContext.getProps());
        if (federationContext.isPreview() || databaseType.getSystemSchemas().contains(schemaName)) {
            federationContext.getExecutionUnits().addAll(context.getExecutionUnits());
            return this.createEmptyEnumerable();
        }
        return this.execute(databaseType, logicSQL, database, context);
    }

    private AbstractEnumerable<Object[]> execute(DatabaseType databaseType, LogicSQL logicSQL, ShardingSphereDatabase database, ExecutionContext context) {
        try {
            ExecutionGroupContext executionGroupContext = this.prepareEngine.prepare(context.getRouteContext(), context.getExecutionUnits());
            this.setParameters(executionGroupContext.getInputGroups());
            ExecuteProcessEngine.initialize((LogicSQL)context.getLogicSQL(), (ExecutionGroupContext)executionGroupContext, (ConfigurationProperties)this.executorContext.getProps());
            List<QueryResult> queryResults = this.execute((ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, databaseType);
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            MergeEngine mergeEngine = new MergeEngine(database, this.executorContext.getProps());
            MergedResult mergedResult = mergeEngine.merge(queryResults, logicSQL.getSqlStatementContext());
            Collection<Statement> statements = this.getStatements(executionGroupContext.getInputGroups());
            AbstractEnumerable<Object[]> abstractEnumerable = this.createEnumerable(mergedResult, queryResults.get(0).getMetaData(), statements);
            return abstractEnumerable;
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private List<QueryResult> execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, DatabaseType databaseType) throws SQLException {
        Collection queryResults = this.jdbcExecutor.execute(executionGroupContext, this.callback).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        LinkedList<QueryResult> result = new LinkedList<QueryResult>();
        for (QueryResult each2 : queryResults) {
            QueryResult queryResult = each2 instanceof JDBCStreamQueryResult ? new JDBCMemoryQueryResult(((JDBCStreamQueryResult)each2).getResultSet(), databaseType) : each2;
            result.add(queryResult);
        }
        return result;
    }

    private Collection<Statement> getStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                result.add(executionUnit.getStorageResource());
            }
        }
        return result;
    }

    private SqlString createSQLString(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext, DatabaseType databaseType) {
        SqlDialect sqlDialect = SQL_DIALECTS.getOrDefault(databaseType.getClass(), MysqlSqlDialect.DEFAULT);
        return new RelToSqlConverter(sqlDialect).visitRoot(this.createRelNode(tableMetaData, scanContext)).asStatement().toSqlString(sqlDialect);
    }

    private void setParameters(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                if (!(executionUnit.getStorageResource() instanceof PreparedStatement)) continue;
                this.setParameters((PreparedStatement)executionUnit.getStorageResource(), executionUnit.getExecutionUnit().getSqlUnit().getParameters());
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = parameters.get(i);
            preparedStatement.setObject(i + 1, parameter);
        }
    }

    private List<Object> getParameters(ImmutableList<Integer> parameterIndices) {
        if (null == parameterIndices) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Integer each : parameterIndices) {
            result.add(this.executorContext.getFederationContext().getLogicSQL().getParameters().get(each));
        }
        return result;
    }

    private RelNode createRelNode(FederationTableMetaData tableMetaData, FilterableTableScanContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName();
        String schemaName = this.executorContext.getSchemaName();
        RelOptCluster relOptCluster = ((SqlToRelConverter)((OptimizerPlannerContext)this.optimizerContext.getPlannerContexts().get(databaseName)).getConverters().get(schemaName)).getCluster();
        RelOptSchema relOptSchema = (RelOptSchema)((SqlValidator)((OptimizerPlannerContext)this.optimizerContext.getPlannerContexts().get(databaseName)).getValidators().get(schemaName)).getCatalogReader();
        RelBuilder builder = RelFactories.LOGICAL_BUILDER.create(relOptCluster, relOptSchema).scan(new String[]{tableMetaData.getName()}).filter(scanContext.getFilters());
        if (null != scanContext.getProjects()) {
            builder.project(this.createProjections(scanContext.getProjects(), builder, tableMetaData.getColumnNames()));
        }
        return builder.build();
    }

    private Collection<RexNode> createProjections(int[] projects, RelBuilder relBuilder, List<String> columnNames) {
        LinkedList<RexNode> result = new LinkedList<RexNode>();
        for (int each : projects) {
            result.add((RexNode)relBuilder.field(columnNames.get(each)));
        }
        return result;
    }

    private AbstractEnumerable<Object[]> createEnumerable(final MergedResult mergedResult, final QueryResultMetaData metaData, final Collection<Statement> statements) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new FilterableRowEnumerator(mergedResult, metaData, statements);
            }
        };
    }

    private LogicSQL createLogicSQL(Map<String, ShardingSphereDatabase> databases, SqlString sqlString, DatabaseType databaseType) {
        String sql = sqlString.getSql().replace("\n", " ");
        SQLStatement sqlStatement = new SQLStatementParserEngine(databaseType.getType(), this.optimizerContext.getSqlParserRule().getSqlStatementCache(), this.optimizerContext.getSqlParserRule().getParseTreeCache(), this.optimizerContext.getSqlParserRule().isSqlCommentParseEnabled()).parse(sql, false);
        List<Object> parameters = this.getParameters((ImmutableList<Integer>)sqlString.getDynamicParameters());
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance(databases, parameters, (SQLStatement)sqlStatement, (String)this.executorContext.getDatabaseName());
        return new LogicSQL(sqlStatementContext, sql, parameters);
    }

    private AbstractEnumerable<Object[]> createEmptyEnumerable() {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new EmptyRowEnumerator();
            }
        };
    }

    static {
        SQL_DIALECTS.put(H2DatabaseType.class, MysqlSqlDialect.DEFAULT);
        SQL_DIALECTS.put(MySQLDatabaseType.class, MysqlSqlDialect.DEFAULT);
        SQL_DIALECTS.put(MariaDBDatabaseType.class, MysqlSqlDialect.DEFAULT);
        SQL_DIALECTS.put(OracleDatabaseType.class, OracleSqlDialect.DEFAULT);
        SQL_DIALECTS.put(SQLServerDatabaseType.class, MssqlSqlDialect.DEFAULT);
        SQL_DIALECTS.put(PostgreSQLDatabaseType.class, PostgresqlSqlDialect.DEFAULT);
        SQL_DIALECTS.put(OpenGaussDatabaseType.class, PostgresqlSqlDialect.DEFAULT);
    }
}

