/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;

public final class CreateViewStatementSchemaRefresher
implements MetaDataRefresher<CreateViewStatement> {
    private static final String TYPE = CreateViewStatement.class.getName();

    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String schemaName, CreateViewStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String viewName = sqlStatement.getView().getTableName().getIdentifier().getValue();
        if (!this.containsInImmutableDataNodeContainedRule(viewName, database)) {
            database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, viewName));
        }
        GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResource().getDatabaseType(), database.getResource().getDataSources(), database.getRuleMetaData().getRules(), props, schemaName);
        Map schemaMap = GenericSchemaBuilder.build(Collections.singletonList(viewName), (GenericSchemaBuilderMaterials)materials);
        Optional<ShardingSphereTable> actualViewMetaData = Optional.ofNullable((ShardingSphereSchema)schemaMap.get(schemaName)).map(optional -> (ShardingSphereTable)optional.getTables().get(viewName));
        if (actualViewMetaData.isPresent()) {
            ((ShardingSphereSchema)database.getSchemas().get(schemaName)).put(viewName, actualViewMetaData.get());
            federationDatabaseMetaData.putTable(schemaName, actualViewMetaData.get());
            optimizerPlanners.put(federationDatabaseMetaData.getName(), OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
            SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
            event.getAlteredTables().add(actualViewMetaData.get());
            return Optional.of(event);
        }
        return Optional.empty();
    }

    private boolean containsInImmutableDataNodeContainedRule(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return TYPE;
    }
}

