/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;

public class IndexMetaDataUtil {
    private static final String UNDERLINE = "_";
    private static final String GENERATED_LOGIC_INDEX_NAME_SUFFIX = "idx";

    public static String getLogicIndexName(String actualIndexName, String actualTableName) {
        String indexNameSuffix = UNDERLINE + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? actualIndexName.substring(0, actualIndexName.lastIndexOf(indexNameSuffix)) : actualIndexName;
    }

    public static String getActualIndexName(String logicIndexName, String actualTableName) {
        return Strings.isNullOrEmpty((String)actualTableName) ? logicIndexName : logicIndexName + UNDERLINE + actualTableName;
    }

    public static String getGeneratedLogicIndexName(Collection<ColumnSegment> columns) {
        StringBuilder builder = new StringBuilder();
        for (ColumnSegment each : columns) {
            builder.append(each.getIdentifier().getValue()).append(UNDERLINE);
        }
        return builder.append(GENERATED_LOGIC_INDEX_NAME_SUFFIX).toString();
    }

    public static Collection<QualifiedTable> getTableNames(ShardingSphereDatabase database, DatabaseType type, Collection<IndexSegment> indexes) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        String schemaName = DatabaseTypeEngine.getDefaultSchemaName(type, database.getName());
        for (IndexSegment each : indexes) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(schemaName);
            IndexMetaDataUtil.findLogicTableNameFromMetaData(database.getSchemas().get(actualSchemaName), each.getIndexName().getIdentifier().getValue()).ifPresent(optional -> result.add(new QualifiedTable(actualSchemaName, (String)optional)));
        }
        return result;
    }

    private static Optional<String> findLogicTableNameFromMetaData(ShardingSphereSchema schema, String logicIndexName) {
        for (String each : schema.getAllTableNames()) {
            if (!schema.get(each).getIndexes().containsKey(logicIndexName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    @Generated
    private IndexMetaDataUtil() {
    }
}

