/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;

public final class InstanceContext {
    private final ComputeNodeInstance instance;
    private final WorkerIdGenerator workerIdGenerator;
    private final ModeConfiguration modeConfiguration;
    private final LockContext lockContext;
    private final Collection<ComputeNodeInstance> computeNodeInstances = new LinkedList<ComputeNodeInstance>();

    public InstanceContext(ComputeNodeInstance instance, WorkerIdGenerator workerIdGenerator, ModeConfiguration modeConfiguration, LockContext lockContext) {
        this.instance = instance;
        this.workerIdGenerator = workerIdGenerator;
        this.modeConfiguration = modeConfiguration;
        this.lockContext = lockContext;
        this.initLockContext();
        this.getWorkerId();
    }

    public void updateInstanceStatus(String instanceId, Collection<String> status) {
        if (this.instance.getInstanceDefinition().getInstanceId().equals(instanceId)) {
            this.instance.switchState(status);
        }
        this.updateRelatedComputeNodeInstancesStatus(instanceId, status);
    }

    private void updateRelatedComputeNodeInstancesStatus(String instanceId, Collection<String> status) {
        for (ComputeNodeInstance each : this.computeNodeInstances) {
            if (!each.getInstanceDefinition().getInstanceId().equals(instanceId)) continue;
            each.switchState(status);
        }
    }

    public void updateWorkerId(Long workerId) {
        if (!Objects.equals(workerId, this.instance.getWorkerId())) {
            this.instance.setWorkerId(workerId);
        }
    }

    public void updateLabel(String instanceId, Collection<String> labels) {
        if (this.instance.getInstanceDefinition().getInstanceId().equals(instanceId)) {
            this.instance.setLabels(labels);
        }
        this.computeNodeInstances.stream().filter(each -> each.getInstanceDefinition().getInstanceId().equals(instanceId)).forEach(each -> each.setLabels(labels));
    }

    public boolean addXaRecoveryId(String instanceId, String xaRecoveryId) {
        if (instanceId.equals(this.instance.getCurrentInstanceId()) && !this.instance.getXaRecoveryIds().contains(xaRecoveryId)) {
            this.instance.getXaRecoveryIds().add(xaRecoveryId);
            this.computeNodeInstances.stream().filter(each -> each.getInstanceDefinition().getInstanceId().equals(instanceId)).forEach(each -> each.getXaRecoveryIds().add(xaRecoveryId));
            return true;
        }
        this.computeNodeInstances.stream().filter(each -> each.getInstanceDefinition().getInstanceId().equals(instanceId)).forEach(each -> each.getXaRecoveryIds().add(xaRecoveryId));
        return false;
    }

    public boolean deleteXaRecoveryId(String instanceId, String xaRecoveryId) {
        if (instanceId.equals(this.instance.getCurrentInstanceId()) && this.instance.getXaRecoveryIds().contains(xaRecoveryId)) {
            this.instance.getXaRecoveryIds().remove(xaRecoveryId);
            this.computeNodeInstances.stream().filter(each -> each.getInstanceDefinition().getInstanceId().equals(instanceId)).forEach(each -> each.getXaRecoveryIds().remove(xaRecoveryId));
            return true;
        }
        this.computeNodeInstances.stream().filter(each -> each.getInstanceDefinition().getInstanceId().equals(instanceId)).forEach(each -> each.getXaRecoveryIds().remove(xaRecoveryId));
        return false;
    }

    public long getWorkerId() {
        if (null == this.instance.getWorkerId()) {
            Optional.of(this.workerIdGenerator.generate()).ifPresent(this.instance::setWorkerId);
        }
        return this.instance.getWorkerId();
    }

    public void addComputeNodeInstance(ComputeNodeInstance instance) {
        this.computeNodeInstances.removeIf(each -> each.getInstanceDefinition().getInstanceId().equalsIgnoreCase(instance.getInstanceDefinition().getInstanceId()));
        this.computeNodeInstances.add(instance);
    }

    public void deleteComputeNodeInstance(ComputeNodeInstance instance) {
        this.computeNodeInstances.removeIf(each -> each.getInstanceDefinition().getInstanceId().equalsIgnoreCase(instance.getInstanceDefinition().getInstanceId()));
    }

    public List<InstanceDefinition> getComputeNodeInstances(InstanceType instanceType, Collection<String> labels) {
        ArrayList<InstanceDefinition> result = new ArrayList<InstanceDefinition>(this.computeNodeInstances.size());
        for (ComputeNodeInstance each : this.computeNodeInstances) {
            if (each.getInstanceDefinition().getInstanceType() != instanceType) continue;
            if (!labels.stream().anyMatch(each.getLabels()::contains)) continue;
            result.add(each.getInstanceDefinition());
        }
        return result;
    }

    public Optional<ComputeNodeInstance> getComputeNodeInstanceById(String instanceId) {
        return this.computeNodeInstances.stream().filter(each -> instanceId.equals(each.getCurrentInstanceId())).findFirst();
    }

    public void initLockContext() {
        this.lockContext.initLockState(this);
    }

    public boolean isCluster() {
        return "Cluster".equalsIgnoreCase(this.modeConfiguration.getType());
    }

    @Generated
    public ComputeNodeInstance getInstance() {
        return this.instance;
    }

    @Generated
    public WorkerIdGenerator getWorkerIdGenerator() {
        return this.workerIdGenerator;
    }

    @Generated
    public ModeConfiguration getModeConfiguration() {
        return this.modeConfiguration;
    }

    @Generated
    public LockContext getLockContext() {
        return this.lockContext;
    }

    @Generated
    public Collection<ComputeNodeInstance> getComputeNodeInstances() {
        return this.computeNodeInstances;
    }
}

