/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.infra.state.StateType;

public final class ComputeNodeInstance {
    private final InstanceDefinition instanceDefinition;
    private Collection<String> labels;
    private final StateContext state = new StateContext();
    private Long workerId;
    private List<String> xaRecoveryIds = new LinkedList<String>();

    public void setLabels(Collection<String> labels) {
        if (null == labels) {
            return;
        }
        this.labels = labels;
    }

    public void switchState(Collection<String> status) {
        this.state.switchState(StateType.CIRCUIT_BREAK, null != status && status.contains(StateType.CIRCUIT_BREAK.name()));
    }

    public String getCurrentInstanceId() {
        return this.instanceDefinition.getInstanceId();
    }

    @Generated
    public ComputeNodeInstance(InstanceDefinition instanceDefinition) {
        this.instanceDefinition = instanceDefinition;
    }

    @Generated
    public InstanceDefinition getInstanceDefinition() {
        return this.instanceDefinition;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    @Generated
    public StateContext getState() {
        return this.state;
    }

    @Generated
    public Long getWorkerId() {
        return this.workerId;
    }

    @Generated
    public List<String> getXaRecoveryIds() {
        return this.xaRecoveryIds;
    }

    @Generated
    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }

    @Generated
    public void setXaRecoveryIds(List<String> xaRecoveryIds) {
        this.xaRecoveryIds = xaRecoveryIds;
    }
}

