/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.spring.boot;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spring.boot.algorithm.EncryptAlgorithmProvidedBeanRegistry;
import org.apache.shardingsphere.encrypt.spring.boot.condition.EncryptSpringBootCondition;
import org.apache.shardingsphere.encrypt.spring.boot.rule.YamlEncryptRuleSpringBootConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleAlgorithmProviderConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={YamlEncryptRuleSpringBootConfiguration.class})
@ConditionalOnClass(value={YamlEncryptRuleConfiguration.class})
@Conditional(value={EncryptSpringBootCondition.class})
public class EncryptRuleSpringBootConfiguration {
    private final EncryptRuleAlgorithmProviderConfigurationYamlSwapper swapper = new EncryptRuleAlgorithmProviderConfigurationYamlSwapper();
    private final YamlEncryptRuleSpringBootConfiguration yamlConfig;

    @Bean
    public RuleConfiguration encryptRuleConfiguration(ObjectProvider<Map<String, EncryptAlgorithm<?, ?>>> encryptors) {
        AlgorithmProvidedEncryptRuleConfiguration result = this.swapper.swapToObject(this.yamlConfig.getEncrypt());
        result.setEncryptors(Optional.ofNullable((Map)encryptors.getIfAvailable()).orElse(Collections.emptyMap()));
        result.setQueryWithCipherColumn(this.yamlConfig.getEncrypt().isQueryWithCipherColumn());
        return result;
    }

    @Bean
    public static EncryptAlgorithmProvidedBeanRegistry encryptAlgorithmProvidedBeanRegistry(Environment environment) {
        return new EncryptAlgorithmProvidedBeanRegistry(environment);
    }

    @Generated
    public EncryptRuleSpringBootConfiguration(YamlEncryptRuleSpringBootConfiguration yamlConfig) {
        this.yamlConfig = yamlConfig;
    }
}

