/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.statement;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.parser.operation.DistSQLOperationTypeEnum;

public enum DistSQLStatementType {
    RQL{

        @Override
        public Collection<DistSQLOperationTypeEnum> getOperationTypes() {
            return Collections.singletonList(DistSQLOperationTypeEnum.SHOW);
        }
    }
    ,
    RDL{

        @Override
        public Collection<DistSQLOperationTypeEnum> getOperationTypes() {
            return Arrays.asList(DistSQLOperationTypeEnum.ADD, DistSQLOperationTypeEnum.ALTER, DistSQLOperationTypeEnum.CREATE, DistSQLOperationTypeEnum.DROP);
        }
    }
    ,
    RAL{

        @Override
        public Collection<DistSQLOperationTypeEnum> getOperationTypes() {
            return Collections.singletonList(DistSQLOperationTypeEnum.RAL_OPERATION);
        }
    };


    public abstract Collection<DistSQLOperationTypeEnum> getOperationTypes();

    public static DistSQLStatementType getValueOf(String statementTypeName) {
        try {
            return DistSQLStatementType.valueOf(statementTypeName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException(String.format("Unsupported statement type `%s`", statementTypeName));
        }
    }
}

