/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.common;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.CommonDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.CommonDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.parser.segment.CacheOptionSegment;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.TrafficRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.TransactionProviderSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.hint.ClearHintStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.CountInstanceRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowAuthorityRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowInstanceModeStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowSQLParserRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowTrafficRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowTransactionRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.queryable.ShowVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterSQLParserRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterTrafficRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.AlterTransactionRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.ApplyDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.CreateTrafficRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.DiscardDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.DropTrafficRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.LabelInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.PrepareDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.RefreshTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.SetInstanceStatusStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.SetVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.updatable.UnlabelInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.CreateDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.CountDatabaseRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowResourcesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowRulesUsedResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowUnusedResourcesStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class CommonDistSQLStatementVisitor
extends CommonDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitAddResource(CommonDistSQLStatementParser.AddResourceContext ctx) {
        return new AddResourceStatement((Collection)ctx.dataSource().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterResource(CommonDistSQLStatementParser.AlterResourceContext ctx) {
        return new AlterResourceStatement((Collection)ctx.dataSource().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowTableMetadata(CommonDistSQLStatementParser.ShowTableMetadataContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
        return new ShowTableMetadataStatement(tableNames, null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitDataSource(CommonDistSQLStatementParser.DataSourceContext ctx) {
        String url = null;
        String hostname = null;
        String port = null;
        String dbName = null;
        if (null != ctx.urlSource()) {
            url = new IdentifierValue(ctx.urlSource().url().getText()).getValue();
        }
        if (null != ctx.simpleSource()) {
            hostname = ctx.simpleSource().hostname().getText();
            port = ctx.simpleSource().port().getText();
            dbName = ctx.simpleSource().dbName().getText();
        }
        String password = null == ctx.password() ? "" : this.getPassword(ctx.password());
        Properties props = this.getProperties(ctx.propertiesDefinition());
        return new DataSourceSegment(this.getIdentifierValue((ParseTree)ctx.dataSourceName()), url, hostname, port, dbName, ctx.user().getText(), password, props);
    }

    private String getPassword(List<CommonDistSQLStatementParser.PasswordContext> passwordContexts) {
        return passwordContexts.stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.joining(""));
    }

    @Override
    public ASTNode visitShowInstance(CommonDistSQLStatementParser.ShowInstanceContext ctx) {
        return new ShowInstanceStatement();
    }

    @Override
    public ASTNode visitShowInstanceMode(CommonDistSQLStatementParser.ShowInstanceModeContext ctx) {
        return new ShowInstanceModeStatement();
    }

    @Override
    public ASTNode visitEnableInstance(CommonDistSQLStatementParser.EnableInstanceContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.ENABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitDisableInstance(CommonDistSQLStatementParser.DisableInstanceContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.DISABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitLabelInstance(CommonDistSQLStatementParser.LabelInstanceContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new LabelInstanceStatement(ctx.RELABEL() != null, this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    @Override
    public ASTNode visitUnlabelInstance(CommonDistSQLStatementParser.UnlabelInstanceContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new UnlabelInstanceStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    private SetInstanceStatusStatement buildSetInstanceStatusStatement(String status, CommonDistSQLStatementParser.InstanceIdContext instanceIdContext) {
        return new SetInstanceStatusStatement(status, this.getIdentifierValue((ParseTree)instanceIdContext));
    }

    @Override
    public ASTNode visitCountInstanceRules(CommonDistSQLStatementParser.CountInstanceRulesContext ctx) {
        return new CountInstanceRulesStatement();
    }

    @Override
    public ASTNode visitAlterInstance(CommonDistSQLStatementParser.AlterInstanceContext ctx) {
        return new AlterInstanceStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValues()));
    }

    @Override
    public ASTNode visitCountDatabaseRules(CommonDistSQLStatementParser.CountDatabaseRulesContext ctx) {
        return new CountDatabaseRulesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitCreateDefaultSingleTableRule(CommonDistSQLStatementParser.CreateDefaultSingleTableRuleContext ctx) {
        return new CreateDefaultSingleTableRuleStatement(this.getIdentifierValue((ParseTree)ctx.dataSourceName()));
    }

    @Override
    public ASTNode visitAlterDefaultSingleTableRule(CommonDistSQLStatementParser.AlterDefaultSingleTableRuleContext ctx) {
        return new AlterDefaultSingleTableRuleStatement(this.getIdentifierValue((ParseTree)ctx.dataSourceName()));
    }

    @Override
    public ASTNode visitDropDefaultSingleTableRule(CommonDistSQLStatementParser.DropDefaultSingleTableRuleContext ctx) {
        return new DropDefaultSingleTableRuleStatement(null != ctx.existClause());
    }

    private Properties getProperties(CommonDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (CommonDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitDropResource(CommonDistSQLStatementParser.DropResourceContext ctx) {
        boolean ignoreSingleTables = null != ctx.ignoreSingleTables();
        return new DropResourceStatement(ctx.existClause() != null, (Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()), ignoreSingleTables);
    }

    @Override
    public ASTNode visitShowResources(CommonDistSQLStatementParser.ShowResourcesContext ctx) {
        return new ShowResourcesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowUnusedResources(CommonDistSQLStatementParser.ShowUnusedResourcesContext ctx) {
        return new ShowUnusedResourcesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitDatabaseName(CommonDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSetVariable(CommonDistSQLStatementParser.SetVariableContext ctx) {
        return new SetVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValue()));
    }

    @Override
    public ASTNode visitShowSingleTableRules(CommonDistSQLStatementParser.ShowSingleTableRulesContext ctx) {
        return new ShowSingleTableRulesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowSingleTable(CommonDistSQLStatementParser.ShowSingleTableContext ctx) {
        return new ShowSingleTableStatement(null == ctx.table() ? null : this.getIdentifierValue((ParseTree)ctx.table().tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowVariable(CommonDistSQLStatementParser.ShowVariableContext ctx) {
        return new ShowVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()).toUpperCase());
    }

    @Override
    public ASTNode visitShowAllVariables(CommonDistSQLStatementParser.ShowAllVariablesContext ctx) {
        return new ShowVariableStatement();
    }

    @Override
    public ASTNode visitClearHint(CommonDistSQLStatementParser.ClearHintContext ctx) {
        return new ClearHintStatement();
    }

    @Override
    public ASTNode visitRefreshTableMetadata(CommonDistSQLStatementParser.RefreshTableMetadataContext ctx) {
        if (null == ctx.refreshScope()) {
            return new RefreshTableMetadataStatement();
        }
        String resourceName = null;
        String schemaName = null;
        String tableName = this.getIdentifierValue((ParseTree)ctx.refreshScope().tableName());
        if (null != ctx.refreshScope().fromSegment()) {
            CommonDistSQLStatementParser.FromSegmentContext fromSegment = ctx.refreshScope().fromSegment();
            resourceName = this.getIdentifierValue((ParseTree)fromSegment.resourceName());
            schemaName = null == fromSegment.schemaName() ? null : this.getIdentifierValue((ParseTree)fromSegment.schemaName());
        }
        return new RefreshTableMetadataStatement(tableName, resourceName, schemaName);
    }

    @Override
    public ASTNode visitShowAuthorityRule(CommonDistSQLStatementParser.ShowAuthorityRuleContext ctx) {
        return new ShowAuthorityRuleStatement();
    }

    @Override
    public ASTNode visitShowTransactionRule(CommonDistSQLStatementParser.ShowTransactionRuleContext ctx) {
        return new ShowTransactionRuleStatement();
    }

    @Override
    public ASTNode visitAlterTransactionRule(CommonDistSQLStatementParser.AlterTransactionRuleContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.transactionRuleDefinition());
    }

    @Override
    public ASTNode visitDropTrafficRule(CommonDistSQLStatementParser.DropTrafficRuleContext ctx) {
        Collection ruleNames = null == ctx.ruleName() ? null : (Collection)ctx.ruleName().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
        return new DropTrafficRuleStatement(ruleNames, null != ctx.ifExists());
    }

    @Override
    public ASTNode visitTransactionRuleDefinition(CommonDistSQLStatementParser.TransactionRuleDefinitionContext ctx) {
        String defaultType = this.getIdentifierValue((ParseTree)ctx.defaultType());
        TransactionProviderSegment provider = (TransactionProviderSegment)this.visit((ParseTree)ctx.providerDefinition());
        return new AlterTransactionRuleStatement(defaultType, provider);
    }

    @Override
    public ASTNode visitProviderDefinition(CommonDistSQLStatementParser.ProviderDefinitionContext ctx) {
        return new TransactionProviderSegment(this.getIdentifierValue((ParseTree)ctx.providerName()), this.getProperties(ctx.propertiesDefinition()));
    }

    @Override
    public ASTNode visitShowSQLParserRule(CommonDistSQLStatementParser.ShowSQLParserRuleContext ctx) {
        return new ShowSQLParserRuleStatement();
    }

    @Override
    public ASTNode visitAlterSQLParserRule(CommonDistSQLStatementParser.AlterSQLParserRuleContext ctx) {
        return (ASTNode)super.visit((ParseTree)ctx.sqlParserRuleDefinition());
    }

    @Override
    public ASTNode visitSqlParserRuleDefinition(CommonDistSQLStatementParser.SqlParserRuleDefinitionContext ctx) {
        AlterSQLParserRuleStatement result = new AlterSQLParserRuleStatement();
        result.setSqlCommentParseEnable(null == ctx.sqlCommentParseEnable() ? null : Boolean.valueOf(Boolean.parseBoolean(this.getIdentifierValue((ParseTree)ctx.sqlCommentParseEnable()))));
        result.setParseTreeCache(null == ctx.parseTreeCache() ? null : this.visitCacheOption(ctx.parseTreeCache().cacheOption()));
        result.setSqlStatementCache(null == ctx.sqlStatementCache() ? null : this.visitCacheOption(ctx.sqlStatementCache().cacheOption()));
        return result;
    }

    @Override
    public CacheOptionSegment visitCacheOption(CommonDistSQLStatementParser.CacheOptionContext ctx) {
        return new CacheOptionSegment(null == ctx.initialCapacity() ? null : Integer.valueOf(Integer.parseInt(this.getIdentifierValue((ParseTree)ctx.initialCapacity()))), null == ctx.maximumSize() ? null : Long.valueOf(Long.parseLong(this.getIdentifierValue((ParseTree)ctx.maximumSize()))));
    }

    @Override
    public ASTNode visitCreateTrafficRule(CommonDistSQLStatementParser.CreateTrafficRuleContext ctx) {
        return new CreateTrafficRuleStatement((Collection)ctx.trafficRuleDefinition().stream().map(each -> (TrafficRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterTrafficRule(CommonDistSQLStatementParser.AlterTrafficRuleContext ctx) {
        return new AlterTrafficRuleStatement((Collection)ctx.trafficRuleDefinition().stream().map(each -> (TrafficRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowTrafficRules(CommonDistSQLStatementParser.ShowTrafficRulesContext ctx) {
        ShowTrafficRulesStatement result = new ShowTrafficRulesStatement();
        if (null != ctx.ruleName()) {
            result.setRuleName(this.getIdentifierValue((ParseTree)ctx.ruleName()));
        }
        return result;
    }

    @Override
    public ASTNode visitTrafficRuleDefinition(CommonDistSQLStatementParser.TrafficRuleDefinitionContext ctx) {
        AlgorithmSegment loadBalancerSegment = null;
        if (null != ctx.loadBalancerDefinition()) {
            loadBalancerSegment = (AlgorithmSegment)this.visit((ParseTree)ctx.loadBalancerDefinition().algorithmDefinition());
        }
        return new TrafficRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.buildLabels(ctx.labelDefinition()), (AlgorithmSegment)this.visit((ParseTree)ctx.trafficAlgorithmDefinition().algorithmDefinition()), loadBalancerSegment);
    }

    @Override
    public ASTNode visitLoadBalancerDefinition(CommonDistSQLStatementParser.LoadBalancerDefinitionContext ctx) {
        if (null == ctx) {
            return null;
        }
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitAlgorithmDefinition(CommonDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.typeName()), this.buildProperties(ctx.algorithmProperties()));
    }

    private Properties buildProperties(CommonDistSQLStatementParser.AlgorithmPropertiesContext algorithmProps) {
        Properties result = new Properties();
        if (null == algorithmProps) {
            return result;
        }
        for (CommonDistSQLStatementParser.AlgorithmPropertyContext each : algorithmProps.algorithmProperty()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    private Collection<String> buildLabels(CommonDistSQLStatementParser.LabelDefinitionContext labelDefinition) {
        if (null == labelDefinition) {
            return Collections.emptyList();
        }
        return labelDefinition.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
    }

    @Override
    public ASTNode visitExportDatabaseConfiguration(CommonDistSQLStatementParser.ExportDatabaseConfigurationContext ctx) {
        return new ExportDatabaseConfigurationStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitShowRulesUsedResource(CommonDistSQLStatementParser.ShowRulesUsedResourceContext ctx) {
        return new ShowRulesUsedResourceStatement(this.getIdentifierValue((ParseTree)ctx.resourceName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitPrepareDistSQL(CommonDistSQLStatementParser.PrepareDistSQLContext ctx) {
        return new PrepareDistSQLStatement();
    }

    @Override
    public ASTNode visitApplyDistSQL(CommonDistSQLStatementParser.ApplyDistSQLContext ctx) {
        return new ApplyDistSQLStatement();
    }

    @Override
    public ASTNode visitDiscardDistSQL(CommonDistSQLStatementParser.DiscardDistSQLContext ctx) {
        return new DiscardDistSQLStatement();
    }

    @Override
    public ASTNode visitImportDatabaseConfiguration(CommonDistSQLStatementParser.ImportDatabaseConfigurationContext ctx) {
        return new ImportDatabaseConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }
}

