/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.rulealtered;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.TableName;

public final class ImporterConfiguration {
    private final PipelineDataSourceConfiguration dataSourceConfig;
    private final Map<LogicTableName, Set<String>> shardingColumnsMap;
    private final TableNameSchemaNameMapping tableNameSchemaNameMapping;
    private final int batchSize;
    private final int retryTimes;

    public Collection<String> getLogicTableNames() {
        List result = this.shardingColumnsMap.keySet().stream().map(TableName::getLowercase).collect(Collectors.toList());
        return Collections.unmodifiableList(result);
    }

    public Set<String> getShardingColumns(String logicTableName) {
        return this.shardingColumnsMap.get(new LogicTableName(logicTableName));
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return this.tableNameSchemaNameMapping.getSchemaName(logicTableName);
    }

    @Generated
    public ImporterConfiguration(PipelineDataSourceConfiguration dataSourceConfig, Map<LogicTableName, Set<String>> shardingColumnsMap, TableNameSchemaNameMapping tableNameSchemaNameMapping, int batchSize, int retryTimes) {
        this.dataSourceConfig = dataSourceConfig;
        this.shardingColumnsMap = shardingColumnsMap;
        this.tableNameSchemaNameMapping = tableNameSchemaNameMapping;
        this.batchSize = batchSize;
        this.retryTimes = retryTimes;
    }

    @Generated
    public PipelineDataSourceConfiguration getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Generated
    public Map<LogicTableName, Set<String>> getShardingColumnsMap() {
        return this.shardingColumnsMap;
    }

    @Generated
    public TableNameSchemaNameMapping getTableNameSchemaNameMapping() {
        return this.tableNameSchemaNameMapping;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public String toString() {
        return "ImporterConfiguration(shardingColumnsMap=" + this.getShardingColumnsMap() + ", tableNameSchemaNameMapping=" + this.getTableNameSchemaNameMapping() + ", batchSize=" + this.getBatchSize() + ", retryTimes=" + this.getRetryTimes() + ")";
    }
}

