/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ArrayBackedTag
implements Tag {
    private final byte type;
    private final byte[] bytes;
    private int offset = 0;
    private int length = 0;

    public ArrayBackedTag(byte tagType, String tag) {
        this(tagType, Bytes.toBytes(tag));
    }

    public ArrayBackedTag(byte tagType, byte[] tag) {
        int tagLength = tag.length + 1;
        if (tagLength > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.length = 2 + tagLength;
        this.bytes = new byte[this.length];
        int pos = Bytes.putAsShort(this.bytes, 0, tagLength);
        pos = Bytes.putByte(this.bytes, pos, tagType);
        Bytes.putBytes(this.bytes, pos, tag, 0, tag.length);
        this.type = tagType;
    }

    public ArrayBackedTag(byte[] bytes, int offset) {
        this(bytes, offset, ArrayBackedTag.getLength(bytes, offset));
    }

    private static int getLength(byte[] bytes, int offset) {
        return 2 + Bytes.readAsInt(bytes, offset, 2);
    }

    public ArrayBackedTag(byte[] bytes, int offset, int length) {
        if (length > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.type = bytes[offset + 2];
    }

    @Override
    public byte[] getValueArray() {
        return this.bytes;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int getValueLength() {
        return this.length - 3;
    }

    @Override
    public int getValueOffset() {
        return this.offset + 3;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        return ByteBuffer.wrap(this.bytes);
    }

    public String toString() {
        return "[Tag type : " + this.type + ", value : " + Bytes.toStringBinary(this.bytes, this.getValueOffset(), this.getValueLength()) + "]";
    }
}

