/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import org.apache.oro.text.awk.AwkPattern;
import org.apache.oro.text.awk.CatNode;
import org.apache.oro.text.awk.CharacterClassNode;
import org.apache.oro.text.awk.NegativeCharacterClassNode;
import org.apache.oro.text.awk.OrNode;
import org.apache.oro.text.awk.PlusNode;
import org.apache.oro.text.awk.QuestionNode;
import org.apache.oro.text.awk.StarNode;
import org.apache.oro.text.awk.SyntaxNode;
import org.apache.oro.text.awk.SyntaxTree;
import org.apache.oro.text.awk.TokenNode;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public final class AwkCompiler
implements PatternCompiler {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 2;
    static final char _END_OF_INPUT = '\uffff';
    private boolean __inCharacterClass;
    private boolean __caseSensitive;
    private boolean __multiline;
    private boolean __beginAnchor;
    private boolean __endAnchor;
    private char __lookahead;
    private int __position;
    private int __bytesRead;
    private int __expressionLength;
    private char[] __regularExpression;
    private int __openParen;
    private int __closeParen;

    private static boolean __isMetachar(char token) {
        return token == '*' || token == '?' || token == '+' || token == '[' || token == ']' || token == '(' || token == ')' || token == '|' || token == '.';
    }

    static boolean _isWordCharacter(char token) {
        return token >= 'a' && token <= 'z' || token >= 'A' && token <= 'Z' || token >= '0' && token <= '9' || token == '_';
    }

    static boolean _isLowerCase(char token) {
        return token >= 'a' && token <= 'z';
    }

    static boolean _isUpperCase(char token) {
        return token >= 'A' && token <= 'Z';
    }

    static char _toggleCase(char token) {
        if (AwkCompiler._isUpperCase(token)) {
            return (char)(token + 32);
        }
        if (AwkCompiler._isLowerCase(token)) {
            return (char)(token - 32);
        }
        return token;
    }

    private void __match(char token) throws MalformedPatternException {
        if (token == this.__lookahead) {
            this.__lookahead = this.__bytesRead < this.__expressionLength ? this.__regularExpression[this.__bytesRead++] : (char)65535;
        } else {
            throw new MalformedPatternException("token: " + token + " does not match lookahead: " + this.__lookahead + " at position: " + this.__bytesRead);
        }
    }

    private void __putback() {
        if (this.__lookahead != '\uffff') {
            --this.__bytesRead;
        }
        this.__lookahead = this.__regularExpression[this.__bytesRead - 1];
    }

    private SyntaxNode __regex() throws MalformedPatternException {
        SyntaxNode left = this.__branch();
        if (this.__lookahead == '|') {
            this.__match('|');
            return new OrNode(left, this.__regex());
        }
        return left;
    }

    private SyntaxNode __branch() throws MalformedPatternException {
        CatNode current;
        SyntaxNode left = this.__piece();
        if (this.__lookahead == ')') {
            if (this.__openParen > this.__closeParen) {
                return left;
            }
            throw new MalformedPatternException("Parse error: close parenthesis without matching open parenthesis at position " + this.__bytesRead);
        }
        if (this.__lookahead == '|' || this.__lookahead == '\uffff') {
            return left;
        }
        CatNode root = current = new CatNode();
        current._left = left;
        while (true) {
            left = this.__piece();
            if (this.__lookahead == ')') {
                if (this.__openParen > this.__closeParen) {
                    current._right = left;
                    break;
                }
                throw new MalformedPatternException("Parse error: close parenthesis without matching open parenthesis at position " + this.__bytesRead);
            }
            if (this.__lookahead == '|' || this.__lookahead == '\uffff') {
                current._right = left;
                break;
            }
            current._right = new CatNode();
            current = (CatNode)current._right;
            current._left = left;
        }
        return root;
    }

    private SyntaxNode __piece() throws MalformedPatternException {
        SyntaxNode left = this.__atom();
        switch (this.__lookahead) {
            case '+': {
                this.__match('+');
                return new PlusNode(left);
            }
            case '?': {
                this.__match('?');
                return new QuestionNode(left);
            }
            case '*': {
                this.__match('*');
                return new StarNode(left);
            }
            case '{': {
                return this.__repetition(left);
            }
        }
        return left;
    }

    private int __parseUnsignedInteger(int radix, int minDigits, int maxDigits) throws MalformedPatternException {
        int num;
        int digits;
        StringBuffer buf = new StringBuffer(4);
        for (digits = 0; Character.digit(this.__lookahead, radix) != -1 && digits < maxDigits; ++digits) {
            buf.append(this.__lookahead);
            this.__match(this.__lookahead);
        }
        if (digits < minDigits || digits > maxDigits) {
            throw new MalformedPatternException("Parse error: unexpected number of digits at position " + this.__bytesRead);
        }
        try {
            num = Integer.parseInt(buf.toString(), radix);
        }
        catch (NumberFormatException e) {
            throw new MalformedPatternException("Parse error: numeric value at position " + this.__bytesRead + " is invalid");
        }
        return num;
    }

    private SyntaxNode __repetition(SyntaxNode atom) throws MalformedPatternException {
        CatNode root = null;
        this.__match('{');
        int min = this.__parseUnsignedInteger(10, 1, Integer.MAX_VALUE);
        int[] startPosition = new int[]{this.__position};
        if (this.__lookahead == '}') {
            CatNode catNode;
            this.__match('}');
            if (min == 0) {
                throw new MalformedPatternException("Parse error: Superfluous interval specified at position " + this.__bytesRead + ".  Number of occurrences was set to zero.");
            }
            if (min == 1) {
                return atom;
            }
            root = catNode = new CatNode();
            catNode._left = atom;
            while (--min > 1) {
                atom = atom._clone(startPosition);
                catNode._right = new CatNode();
                catNode = (CatNode)catNode._right;
                catNode._left = atom;
            }
            catNode._right = atom._clone(startPosition);
        } else if (this.__lookahead == ',') {
            this.__match(',');
            if (this.__lookahead == '}') {
                CatNode catNode;
                this.__match('}');
                if (min == 0) {
                    return new StarNode(atom);
                }
                if (min == 1) {
                    return new PlusNode(atom);
                }
                root = catNode = new CatNode();
                catNode._left = atom;
                while (--min > 0) {
                    atom = atom._clone(startPosition);
                    catNode._right = new CatNode();
                    catNode = (CatNode)catNode._right;
                    catNode._left = atom;
                }
                catNode._right = new StarNode(atom._clone(startPosition));
            } else {
                int max = this.__parseUnsignedInteger(10, 1, Integer.MAX_VALUE);
                this.__match('}');
                if (max < min) {
                    throw new MalformedPatternException("Parse error: invalid interval; " + max + " is less than " + min + " at position " + this.__bytesRead);
                }
                if (max == 0) {
                    throw new MalformedPatternException("Parse error: Superfluous interval specified at position " + this.__bytesRead + ".  Number of occurrences was set to zero.");
                }
                if (min == 0) {
                    CatNode catNode;
                    if (max == 1) {
                        return new QuestionNode(atom);
                    }
                    root = catNode = new CatNode();
                    catNode._left = atom = new QuestionNode(atom);
                    while (--max > 1) {
                        atom = atom._clone(startPosition);
                        catNode._right = new CatNode();
                        catNode = (CatNode)catNode._right;
                        catNode._left = atom;
                    }
                    catNode._right = atom._clone(startPosition);
                } else if (min == max) {
                    CatNode catNode;
                    if (min == 1) {
                        return atom;
                    }
                    root = catNode = new CatNode();
                    catNode._left = atom;
                    while (--min > 1) {
                        atom = atom._clone(startPosition);
                        catNode._right = new CatNode();
                        catNode = (CatNode)catNode._right;
                        catNode._left = atom;
                    }
                    catNode._right = atom._clone(startPosition);
                } else {
                    int count;
                    CatNode catNode;
                    root = catNode = new CatNode();
                    catNode._left = atom;
                    for (count = 1; count < min; ++count) {
                        atom = atom._clone(startPosition);
                        catNode._right = new CatNode();
                        catNode = (CatNode)catNode._right;
                        catNode._left = atom;
                    }
                    atom = new QuestionNode(atom._clone(startPosition));
                    count = max - min;
                    if (count == 1) {
                        catNode._right = atom;
                    } else {
                        catNode._right = new CatNode();
                        catNode = (CatNode)catNode._right;
                        catNode._left = atom;
                        while (--count > 1) {
                            atom = atom._clone(startPosition);
                            catNode._right = new CatNode();
                            catNode = (CatNode)catNode._right;
                            catNode._left = atom;
                        }
                        catNode._right = atom._clone(startPosition);
                    }
                }
            }
        } else {
            throw new MalformedPatternException("Parse error: unexpected character " + this.__lookahead + " in interval at position " + this.__bytesRead);
        }
        this.__position = startPosition[0];
        return root;
    }

    private SyntaxNode __backslashToken() throws MalformedPatternException {
        SyntaxNode current;
        this.__match('\\');
        if (this.__lookahead == 'x') {
            this.__match('x');
            current = this._newTokenNode((char)this.__parseUnsignedInteger(16, 2, 2), this.__position++);
        } else if (this.__lookahead == 'c') {
            this.__match('c');
            char token = Character.toUpperCase(this.__lookahead);
            token = (char)(token > '?' ? token - 64 : token + 64);
            current = new TokenNode(token, this.__position++);
            this.__match(this.__lookahead);
        } else if (this.__lookahead >= '0' && this.__lookahead <= '9') {
            this.__match(this.__lookahead);
            if (this.__lookahead >= '0' && this.__lookahead <= '9') {
                this.__putback();
                int number = this.__parseUnsignedInteger(10, 2, 3);
                number = Integer.parseInt(Integer.toString(number), 8);
                current = this._newTokenNode((char)number, this.__position++);
            } else {
                this.__putback();
                if (this.__lookahead == '0') {
                    this.__match('0');
                    current = new TokenNode('\u0000', this.__position++);
                } else {
                    int number = Character.digit(this.__lookahead, 10);
                    current = this._newTokenNode(this.__lookahead, this.__position++);
                    this.__match(this.__lookahead);
                }
            }
        } else if (this.__lookahead == 'b') {
            current = new TokenNode('\b', this.__position++);
            this.__match('b');
        } else {
            char token = this.__lookahead;
            switch (this.__lookahead) {
                case 'n': {
                    token = '\n';
                    break;
                }
                case 'r': {
                    token = '\r';
                    break;
                }
                case 't': {
                    token = '\t';
                    break;
                }
                case 'f': {
                    token = '\f';
                }
            }
            switch (token) {
                case 'd': {
                    CharacterClassNode characterSet = new CharacterClassNode(this.__position++);
                    characterSet._addTokenRange(48, 57);
                    current = characterSet;
                    break;
                }
                case 'D': {
                    NegativeCharacterClassNode characterSet = new NegativeCharacterClassNode(this.__position++);
                    characterSet._addTokenRange(48, 57);
                    current = characterSet;
                    break;
                }
                case 'w': {
                    CharacterClassNode characterSet = new CharacterClassNode(this.__position++);
                    characterSet._addTokenRange(48, 57);
                    characterSet._addTokenRange(97, 122);
                    characterSet._addTokenRange(65, 90);
                    characterSet._addToken(95);
                    current = characterSet;
                    break;
                }
                case 'W': {
                    NegativeCharacterClassNode characterSet = new NegativeCharacterClassNode(this.__position++);
                    characterSet._addTokenRange(48, 57);
                    characterSet._addTokenRange(97, 122);
                    characterSet._addTokenRange(65, 90);
                    characterSet._addToken(95);
                    current = characterSet;
                    break;
                }
                case 's': {
                    CharacterClassNode characterSet = new CharacterClassNode(this.__position++);
                    characterSet._addToken(32);
                    characterSet._addToken(12);
                    characterSet._addToken(10);
                    characterSet._addToken(13);
                    characterSet._addToken(9);
                    current = characterSet;
                    break;
                }
                case 'S': {
                    NegativeCharacterClassNode characterSet = new NegativeCharacterClassNode(this.__position++);
                    characterSet._addToken(32);
                    characterSet._addToken(12);
                    characterSet._addToken(10);
                    characterSet._addToken(13);
                    characterSet._addToken(9);
                    current = characterSet;
                    break;
                }
                default: {
                    current = this._newTokenNode(token, this.__position++);
                }
            }
            this.__match(this.__lookahead);
        }
        return current;
    }

    private SyntaxNode __atom() throws MalformedPatternException {
        SyntaxNode current;
        if (this.__lookahead == '(') {
            this.__match('(');
            ++this.__openParen;
            current = this.__regex();
            this.__match(')');
            ++this.__closeParen;
        } else if (this.__lookahead == '[') {
            current = this.__characterClass();
        } else if (this.__lookahead == '.') {
            this.__match('.');
            NegativeCharacterClassNode characterSet = new NegativeCharacterClassNode(this.__position++);
            if (this.__multiline) {
                characterSet._addToken(10);
            }
            current = characterSet;
        } else if (this.__lookahead == '\\') {
            current = this.__backslashToken();
        } else if (!AwkCompiler.__isMetachar(this.__lookahead)) {
            current = this._newTokenNode(this.__lookahead, this.__position++);
            this.__match(this.__lookahead);
        } else {
            throw new MalformedPatternException("Parse error: unexpected character " + this.__lookahead + " at position " + this.__bytesRead);
        }
        return current;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SyntaxNode __characterClass() throws MalformedPatternException {
        CharacterClassNode current;
        this.__match('[');
        this.__inCharacterClass = true;
        if (this.__lookahead == '^') {
            this.__match('^');
            current = new NegativeCharacterClassNode(this.__position++);
        } else {
            current = new CharacterClassNode(this.__position++);
        }
        while (this.__lookahead != ']' && this.__lookahead != '\uffff') {
            char token;
            char lastToken;
            SyntaxNode node;
            block14: {
                block13: {
                    if (this.__lookahead != '\\') break block13;
                    node = this.__backslashToken();
                    --this.__position;
                    if (node instanceof TokenNode) {
                        lastToken = ((TokenNode)node)._token;
                        current._addToken(lastToken);
                        if (!this.__caseSensitive) {
                            current._addToken(AwkCompiler._toggleCase(lastToken));
                        }
                        break block14;
                    } else {
                        CharacterClassNode slash = (CharacterClassNode)node;
                        for (token = '\u0000'; token < '\u0100'; token = (char)(token + '\u0001')) {
                            if (!slash._matches(token)) continue;
                            current._addToken(token);
                        }
                        continue;
                    }
                }
                lastToken = this.__lookahead;
                current._addToken(this.__lookahead);
                if (!this.__caseSensitive) {
                    current._addToken(AwkCompiler._toggleCase(this.__lookahead));
                }
                this.__match(this.__lookahead);
            }
            if (this.__lookahead != '-') continue;
            this.__match('-');
            if (this.__lookahead == ']') {
                current._addToken(45);
                break;
            }
            if (this.__lookahead == '\\') {
                node = this.__backslashToken();
                --this.__position;
                if (!(node instanceof TokenNode)) {
                    throw new MalformedPatternException("Parse error: invalid range specified at position " + this.__bytesRead);
                }
                token = ((TokenNode)node)._token;
            } else {
                token = this.__lookahead;
                this.__match(this.__lookahead);
            }
            if (token < lastToken) {
                throw new MalformedPatternException("Parse error: invalid range specified at position " + this.__bytesRead);
            }
            current._addTokenRange(lastToken + '\u0001', token);
            if (this.__caseSensitive) continue;
            current._addTokenRange(AwkCompiler._toggleCase((char)(lastToken + '\u0001')), AwkCompiler._toggleCase(token));
        }
        this.__match(']');
        this.__inCharacterClass = false;
        return current;
    }

    SyntaxNode _newTokenNode(char token, int position) {
        if (!this.__inCharacterClass && !this.__caseSensitive && (AwkCompiler._isUpperCase(token) || AwkCompiler._isLowerCase(token))) {
            CharacterClassNode node = new CharacterClassNode(position);
            node._addToken(token);
            node._addToken(AwkCompiler._toggleCase(token));
            return node;
        }
        return new TokenNode(token, position);
    }

    SyntaxTree _parse(char[] expression) throws MalformedPatternException {
        SyntaxTree tree;
        this.__closeParen = 0;
        this.__openParen = 0;
        this.__regularExpression = expression;
        this.__bytesRead = 0;
        this.__expressionLength = expression.length;
        this.__inCharacterClass = false;
        this.__position = 0;
        this.__match(this.__lookahead);
        if (this.__lookahead == '^') {
            this.__beginAnchor = true;
            this.__match(this.__lookahead);
        }
        if (this.__expressionLength > 0 && expression[this.__expressionLength - 1] == '$') {
            --this.__expressionLength;
            this.__endAnchor = true;
        }
        if (this.__expressionLength > 1 || this.__expressionLength == 1 && !this.__beginAnchor) {
            CatNode root = new CatNode();
            root._left = this.__regex();
            root._right = new TokenNode('\u0100', this.__position++);
            tree = new SyntaxTree(root, this.__position);
        } else {
            tree = new SyntaxTree(new TokenNode('\u0100', 0), 1);
        }
        tree._computeFollowPositions();
        return tree;
    }

    @Override
    public Pattern compile(char[] pattern, int options) throws MalformedPatternException {
        this.__endAnchor = false;
        this.__beginAnchor = false;
        this.__caseSensitive = (options & 1) == 0;
        this.__multiline = (options & 2) != 0;
        SyntaxTree tree = this._parse(pattern);
        AwkPattern regexp = new AwkPattern(new String(pattern), tree);
        regexp._options = options;
        regexp._hasBeginAnchor = this.__beginAnchor;
        regexp._hasEndAnchor = this.__endAnchor;
        return regexp;
    }

    @Override
    public Pattern compile(String pattern, int options) throws MalformedPatternException {
        this.__endAnchor = false;
        this.__beginAnchor = false;
        this.__caseSensitive = (options & 1) == 0;
        this.__multiline = (options & 2) != 0;
        SyntaxTree tree = this._parse(pattern.toCharArray());
        AwkPattern regexp = new AwkPattern(pattern, tree);
        regexp._options = options;
        regexp._hasBeginAnchor = this.__beginAnchor;
        regexp._hasEndAnchor = this.__endAnchor;
        return regexp;
    }

    @Override
    public Pattern compile(char[] pattern) throws MalformedPatternException {
        return this.compile(pattern, 0);
    }

    @Override
    public Pattern compile(String pattern) throws MalformedPatternException {
        return this.compile(pattern, 0);
    }
}

