/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiRetry;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiFlatMapOnFailure;
import io.smallrye.mutiny.operators.MultiMapOnFailure;
import io.smallrye.mutiny.operators.multi.MultiSignalConsumerOp;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MultiOnFailure<T> {
    private final Multi<T> upstream;
    private final Predicate<? super Throwable> predicate;

    public MultiOnFailure(Multi<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate == null ? x -> true : predicate;
    }

    public Multi<T> invoke(Consumer<Throwable> callback) {
        ParameterValidation.nonNull(callback, "callback");
        ParameterValidation.nonNull(this.predicate, "predicate");
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, null, null, failure -> {
            if (this.predicate.test((Throwable)failure)) {
                callback.accept((Throwable)failure);
            }
        }, null, null, null, null));
    }

    public Multi<T> apply(Function<? super Throwable, ? extends Throwable> mapper) {
        return Infrastructure.onMultiCreation(new MultiMapOnFailure<T>(this.upstream, this.predicate, mapper));
    }

    public Multi<T> recoverWithItem(T fallback) {
        ParameterValidation.nonNull(fallback, "fallback");
        return this.recoverWithItem(() -> fallback);
    }

    public Multi<T> recoverWithItem(Supplier<T> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.recoverWithItem((? super Throwable ignored) -> {
            Object t = supplier.get();
            if (t == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            return t;
        });
    }

    public Multi<T> recoverWithCompletion() {
        return this.recoverWithMulti(Multi.createFrom().empty());
    }

    public Multi<T> recoverWithItem(Function<? super Throwable, ? extends T> fallback) {
        ParameterValidation.nonNull(fallback, "fallback");
        return Infrastructure.onMultiCreation(new MultiFlatMapOnFailure<T>(this.upstream, this.predicate, failure -> {
            Object newResult = fallback.apply((Throwable)failure);
            return Multi.createFrom().item(newResult);
        }));
    }

    public Multi<T> recoverWithMulti(Function<? super Throwable, ? extends Multi<? extends T>> fallback) {
        return Infrastructure.onMultiCreation(new MultiFlatMapOnFailure<T>(this.upstream, this.predicate, ParameterValidation.nonNull(fallback, "fallback")));
    }

    public Multi<T> recoverWithMulti(Supplier<? extends Multi<? extends T>> supplier) {
        return this.recoverWithMulti((? super Throwable ignored) -> (Multi)supplier.get());
    }

    public Multi<T> recoverWithMulti(Multi<? extends T> fallback) {
        return this.recoverWithMulti(() -> fallback);
    }

    public MultiRetry<T> retry() {
        return new MultiRetry<T>(this.upstream);
    }
}

