/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock.remote.rpc.handler;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.lock.model.LockInstance;
import com.alibaba.nacos.api.lock.remote.LockOperationEnum;
import com.alibaba.nacos.api.lock.remote.request.LockOperationRequest;
import com.alibaba.nacos.api.lock.remote.response.LockOperationResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.lock.exception.NacosLockException;
import com.alibaba.nacos.lock.service.LockOperationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockRequestHandler
extends RequestHandler<LockOperationRequest, LockOperationResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockRequestHandler.class);
    private final LockOperationService lockOperationService;

    public LockRequestHandler(LockOperationService lockOperationService) {
        this.lockOperationService = lockOperationService;
    }

    public LockOperationResponse handle(LockOperationRequest request, RequestMeta meta) throws NacosException {
        Boolean lock = null;
        LOGGER.info("request: {}, instance: {}", (Object)request.getLockOperationEnum(), (Object)request.getLockInstance());
        try {
            if (request.getLockOperationEnum() == LockOperationEnum.ACQUIRE) {
                LockInstance lockInstance = request.getLockInstance();
                lock = this.lockOperationService.lock(lockInstance);
            } else if (request.getLockOperationEnum() == LockOperationEnum.RELEASE) {
                lock = this.lockOperationService.unLock(request.getLockInstance());
            } else {
                return LockOperationResponse.fail((String)"There is no Handler of such operations!");
            }
            return LockOperationResponse.success((Boolean)lock);
        }
        catch (NacosLockException e) {
            return LockOperationResponse.fail((String)e.getMessage());
        }
    }
}

