/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUtils.class);
    private static final String NO_SPACE_CN = "\u8bbe\u5907\u4e0a\u6ca1\u6709\u7a7a\u95f4";
    private static final String NO_SPACE_EN = "No space left on device";
    private static final String DISK_QUOTA_CN = "\u8d85\u51fa\u78c1\u76d8\u9650\u989d";
    private static final String DISK_QUOTA_EN = "Disk quota exceeded";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final CharsetDecoder DECODER = CHARSET.newDecoder();

    public static String readFile(File file) {
        String string;
        block10: {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            try {
                StringBuilder text = new StringBuilder();
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                CharBuffer charBuffer = CharBuffer.allocate(4096);
                while (fileChannel.read(buffer) != -1) {
                    buffer.flip();
                    DECODER.decode(buffer, charBuffer, false);
                    charBuffer.flip();
                    while (charBuffer.hasRemaining()) {
                        text.append(charBuffer.get());
                    }
                    buffer.clear();
                    charBuffer.clear();
                }
                string = text.toString();
                if (fileChannel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            fileChannel.close();
        }
        return string;
    }

    public static boolean writeFile(File file, byte[] content, boolean append) {
        boolean bl;
        block9: {
            FileChannel fileChannel = new FileOutputStream(file, append).getChannel();
            try {
                ByteBuffer buffer = ByteBuffer.wrap(content);
                fileChannel.write(buffer);
                bl = true;
                if (fileChannel == null) break block9;
            }
            catch (Throwable buffer) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable) {
                            buffer.addSuppressed(throwable);
                        }
                    }
                    throw buffer;
                }
                catch (IOException ioe) {
                    String errMsg;
                    if (ioe.getMessage() != null && (NO_SPACE_CN.equals(errMsg = ioe.getMessage()) || NO_SPACE_EN.equals(errMsg) || errMsg.contains(DISK_QUOTA_CN) || errMsg.contains(DISK_QUOTA_EN))) {
                        LOGGER.warn("\u78c1\u76d8\u6ee1\uff0c\u81ea\u6740\u9000\u51fa");
                        System.exit(0);
                    }
                    return false;
                }
            }
            fileChannel.close();
        }
        return bl;
    }

    public static void deleteQuietly(File file) {
        Objects.requireNonNull(file, "file");
        FileUtils.deleteQuietly((File)file);
    }
}

