/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.exception;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.util.HtmlUtils;

@ControllerAdvice
public class ConsoleExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleExceptionHandler.class);

    @ExceptionHandler(value={AccessException.class})
    private ResponseEntity<String> handleAccessException(AccessException e) {
        LOGGER.error("got exception. {}", (Object)e.getErrMsg());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)e.getErrMsg());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    private ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
    }

    @ExceptionHandler(value={NacosRuntimeException.class})
    private ResponseEntity<String> handleNacosRuntimeException(NacosRuntimeException e) {
        LOGGER.error("got exception. {}", (Object)e.getMessage());
        return ResponseEntity.status((int)e.getErrCode()).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
    }

    @ExceptionHandler(value={Exception.class})
    private ResponseEntity<Object> handleException(HttpServletRequest request, Exception e) {
        String uri = request.getRequestURI();
        LOGGER.error("CONSOLE {}", (Object)uri, (Object)e);
        if (uri.contains("/v2")) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)RestResultUtils.failed((String)HtmlUtils.htmlEscape((String)ExceptionUtil.getAllExceptionMsg((Throwable)e), (String)"utf-8")));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)HtmlUtils.htmlEscape((String)ExceptionUtil.getAllExceptionMsg((Throwable)e), (String)"utf-8"));
    }
}

