/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.core;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.paramcheck.ConsoleDefaultHttpParamExtractor;
import com.alibaba.nacos.console.proxy.core.NamespaceProxy;
import com.alibaba.nacos.core.namespace.model.form.CreateNamespaceForm;
import com.alibaba.nacos.core.namespace.model.form.NamespaceForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/core/namespace"})
@ExtractorManager.Extractor(httpExtractor=ConsoleDefaultHttpParamExtractor.class)
public class ConsoleNamespaceController {
    private final NamespaceProxy namespaceProxy;

    public ConsoleNamespaceController(NamespaceProxy namespaceProxy) {
        this.namespaceProxy = namespaceProxy;
    }

    @GetMapping(value={"/list"})
    @Secured(resource="console/namespaces", action=ActionTypes.READ, signType="console", apiType=ApiType.CONSOLE_API, tags={"only_identity"})
    public Result<List<Namespace>> getNamespaceList() throws NacosException {
        return Result.success(this.namespaceProxy.getNamespaceList());
    }

    @GetMapping
    @Secured(resource="console/namespaces", action=ActionTypes.READ, signType="console", apiType=ApiType.CONSOLE_API)
    public Result<Namespace> getNamespaceDetail(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return Result.success((Object)this.namespaceProxy.getNamespaceDetail(namespaceId));
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console", apiType=ApiType.CONSOLE_API)
    public Result<Boolean> createNamespace(CreateNamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        String namespaceId = namespaceForm.getCustomNamespaceId();
        String namespaceName = namespaceForm.getNamespaceName();
        String namespaceDesc = namespaceForm.getNamespaceDesc();
        return Result.success((Object)this.namespaceProxy.createNamespace(namespaceId, namespaceName, namespaceDesc));
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console", apiType=ApiType.CONSOLE_API)
    public Result<Boolean> updateNamespace(NamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        return Result.success((Object)this.namespaceProxy.updateNamespace(namespaceForm));
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console", apiType=ApiType.CONSOLE_API)
    public Result<Boolean> deleteNamespace(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return Result.success((Object)this.namespaceProxy.deleteNamespace(namespaceId));
    }

    @GetMapping(value={"/exist"})
    @Secured(resource="console/namespaces", action=ActionTypes.READ, signType="console", apiType=ApiType.CONSOLE_API, tags={"only_identity"})
    public Result<Boolean> checkNamespaceIdExist(@RequestParam(value="customNamespaceId") String namespaceId) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return Result.success((Object)false);
        }
        return Result.success((Object)this.namespaceProxy.checkNamespaceIdExist(namespaceId));
    }
}

