/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.model.v2.SupportedLanguage;
import com.alibaba.nacos.console.paramcheck.ConsoleDefaultHttpParamExtractor;
import com.alibaba.nacos.console.proxy.ServerStateProxy;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/server"})
@ExtractorManager.Extractor(httpExtractor=ConsoleDefaultHttpParamExtractor.class)
public class ConsoleServerStateController {
    private final ServerStateProxy serverStateProxy;

    public ConsoleServerStateController(ServerStateProxy serverStateProxy) {
        this.serverStateProxy = serverStateProxy;
    }

    @GetMapping(value={"/state"})
    public ResponseEntity<Map<String, String>> serverState() throws NacosException {
        Map<String, String> serverState = this.serverStateProxy.getServerState();
        return ResponseEntity.ok().body(serverState);
    }

    @GetMapping(value={"/announcement"})
    public Result<String> getAnnouncement(@RequestParam(required=false, name="language", defaultValue="zh-CN") String language) {
        if (!SupportedLanguage.isSupported((String)language)) {
            return Result.failure((String)("Unsupported language: " + language));
        }
        String announcement = this.serverStateProxy.getAnnouncement(language);
        return Result.success((Object)announcement);
    }

    @GetMapping(value={"/guide"})
    public Result<String> getConsoleUiGuide() {
        String guideInformation = this.serverStateProxy.getConsoleUiGuide();
        return Result.success((Object)guideInformation);
    }
}

