/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.cmdb.memory;

import com.alibaba.nacos.api.cmdb.pojo.Entity;
import com.alibaba.nacos.api.cmdb.pojo.EntityEvent;
import com.alibaba.nacos.api.cmdb.pojo.Label;
import com.alibaba.nacos.api.cmdb.spi.CmdbService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.cmdb.core.SwitchAndOptions;
import com.alibaba.nacos.cmdb.service.CmdbReader;
import com.alibaba.nacos.cmdb.service.CmdbWriter;
import com.alibaba.nacos.cmdb.utils.CmdbExecutor;
import com.alibaba.nacos.cmdb.utils.Loggers;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.JacksonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmdbProvider
implements CmdbReader,
CmdbWriter {
    @Autowired
    private SwitchAndOptions switches;
    private CmdbService cmdbService;
    private final Collection<CmdbService> services = NacosServiceLoader.load(CmdbService.class);
    private Map<String, Map<String, Entity>> entityMap = new ConcurrentHashMap<String, Map<String, Entity>>();
    private Map<String, Label> labelMap = new ConcurrentHashMap<String, Label>();
    private Set<String> entityTypeSet = new HashSet<String>();
    private long eventTimestamp = System.currentTimeMillis();

    private void initCmdbService() throws NacosException {
        Iterator<CmdbService> iterator = this.services.iterator();
        if (iterator.hasNext()) {
            this.cmdbService = iterator.next();
        }
        if (this.cmdbService == null && this.switches.isLoadDataAtStart()) {
            throw new NacosException(500, "Cannot initialize CmdbService!");
        }
    }

    public void load() {
        if (!this.switches.isLoadDataAtStart()) {
            return;
        }
        Set labelNames = this.cmdbService.getLabelNames();
        if (labelNames == null || labelNames.isEmpty()) {
            Loggers.MAIN.warn("[LOAD] init label names failed!");
        } else {
            for (String labelName : labelNames) {
                this.labelMap.put(labelName, this.cmdbService.getLabel(labelName));
            }
        }
        this.entityTypeSet = this.cmdbService.getEntityTypes();
        this.entityMap = this.cmdbService.getAllEntities();
    }

    @PostConstruct
    public void init() throws NacosException {
        this.initCmdbService();
        this.load();
        CmdbExecutor.scheduleCmdbTask(new CmdbDumpTask(), this.switches.getDumpTaskInterval(), TimeUnit.SECONDS);
        CmdbExecutor.scheduleCmdbTask(new CmdbLabelTask(), this.switches.getLabelTaskInterval(), TimeUnit.SECONDS);
        CmdbExecutor.scheduleCmdbTask(new CmdbEventTask(), this.switches.getEventTaskInterval(), TimeUnit.SECONDS);
    }

    @Override
    public Entity queryEntity(String entityName, String entityType) {
        if (!this.entityMap.containsKey(entityType)) {
            return null;
        }
        return this.entityMap.get(entityType).get(entityName);
    }

    @Override
    public String queryLabel(String entityName, String entityType, String labelName) {
        Entity entity = this.queryEntity(entityName, entityType);
        if (entity == null) {
            return null;
        }
        return (String)entity.getLabels().get(labelName);
    }

    @Override
    public List<Entity> queryEntitiesByLabel(String labelName, String labelValue) {
        throw new UnsupportedOperationException("Not available now!");
    }

    public void removeEntity(String entityName, String entityType) {
        if (!this.entityMap.containsKey(entityType)) {
            return;
        }
        this.entityMap.get(entityType).remove(entityName);
    }

    public void updateEntity(Entity entity) {
        if (!this.entityTypeSet.contains(entity.getType())) {
            return;
        }
        this.entityMap.get(entity.getType()).put(entity.getName(), entity);
    }

    public class CmdbDumpTask
    implements Runnable {
        @Override
        public void run() {
            try {
                Loggers.MAIN.debug("DUMP-TASK {}", (Object)"start dump.");
                if (CmdbProvider.this.cmdbService == null) {
                    return;
                }
                CmdbProvider.this.entityMap = CmdbProvider.this.cmdbService.getAllEntities();
            }
            catch (Exception e) {
                Loggers.MAIN.error("DUMP-TASK {}", (Object)"dump failed!", (Object)e);
            }
            finally {
                CmdbExecutor.scheduleCmdbTask(this, CmdbProvider.this.switches.getDumpTaskInterval(), TimeUnit.SECONDS);
            }
        }
    }

    public class CmdbLabelTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Loggers.MAIN.debug("LABEL-TASK {}", (Object)"start dump.");
            if (CmdbProvider.this.cmdbService == null) {
                return;
            }
            try {
                HashMap<String, Label> tmpLabelMap = new HashMap<String, Label>(16);
                Set labelNames = CmdbProvider.this.cmdbService.getLabelNames();
                if (labelNames == null || labelNames.isEmpty()) {
                    Loggers.MAIN.warn("CMDB-LABEL-TASK {}", (Object)"load label names failed!");
                } else {
                    for (String labelName : labelNames) {
                        tmpLabelMap.put(labelName, CmdbProvider.this.cmdbService.getLabel(labelName));
                    }
                    if (Loggers.MAIN.isDebugEnabled()) {
                        Loggers.MAIN.debug("LABEL-TASK {}", (Object)("got label map:" + JacksonUtils.toJson(tmpLabelMap)));
                    }
                    CmdbProvider.this.labelMap = tmpLabelMap;
                }
            }
            catch (Exception e) {
                Loggers.MAIN.error("CMDB-LABEL-TASK {}", (Object)"dump failed!", (Object)e);
            }
            finally {
                CmdbExecutor.scheduleCmdbTask(this, CmdbProvider.this.switches.getLabelTaskInterval(), TimeUnit.SECONDS);
            }
        }
    }

    public class CmdbEventTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Loggers.MAIN.debug("EVENT-TASK {}", (Object)"start dump.");
                if (CmdbProvider.this.cmdbService == null) {
                    return;
                }
                long current = System.currentTimeMillis();
                List events = CmdbProvider.this.cmdbService.getEntityEvents(CmdbProvider.this.eventTimestamp);
                CmdbProvider.this.eventTimestamp = current;
                if (Loggers.MAIN.isDebugEnabled()) {
                    Loggers.MAIN.debug("EVENT-TASK {}", (Object)("got events size:, events:" + JacksonUtils.toJson((Object)events)));
                }
                if (events != null && !events.isEmpty()) {
                    for (EntityEvent event : events) {
                        switch (event.getType()) {
                            case ENTITY_REMOVE: {
                                CmdbProvider.this.removeEntity(event.getEntityName(), event.getEntityType());
                                break;
                            }
                            case ENTITY_ADD_OR_UPDATE: {
                                CmdbProvider.this.updateEntity(CmdbProvider.this.cmdbService.getEntity(event.getEntityName(), event.getEntityType()));
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Loggers.MAIN.error("CMDB-EVENT {}", (Object)"event task failed!", (Object)e);
            }
            finally {
                CmdbExecutor.scheduleCmdbTask(this, CmdbProvider.this.switches.getEventTaskInterval(), TimeUnit.SECONDS);
            }
        }
    }
}

