/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.AbstractHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientManager.class);
    private static final HttpClientFactory HTTP_CLIENT_FACTORY = new HttpClientFactory();
    private static final int CON_TIME_OUT_MILLIS = 1000;
    private static final int READ_TIME_OUT_MILLIS = 3000;

    public static HttpClientManager getInstance() {
        return HttpClientManagerInstance.INSTANCE;
    }

    public void shutdown() throws NacosException {
        LOGGER.info("[HttpClientManager] Start destroying NacosRestTemplate");
        try {
            HttpClientBeanHolder.shutdownNacosSyncRest((String)((Object)((Object)HTTP_CLIENT_FACTORY)).getClass().getName());
        }
        catch (Exception ex) {
            LOGGER.error("[HttpClientManager] An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace((Throwable)ex));
        }
        LOGGER.info("[HttpClientManager] Completed destruction of NacosRestTemplate");
    }

    public int getConnectTimeoutOrDefault(int connectTimeout) {
        return Math.max(1000, connectTimeout);
    }

    public NacosRestTemplate getNacosRestTemplate() {
        return HttpClientBeanHolder.getNacosRestTemplate((com.alibaba.nacos.common.http.HttpClientFactory)HTTP_CLIENT_FACTORY);
    }

    private static class HttpClientManagerInstance {
        private static final HttpClientManager INSTANCE = new HttpClientManager();

        private HttpClientManagerInstance() {
        }
    }

    private static class HttpClientFactory
    extends AbstractHttpClientFactory {
        private HttpClientFactory() {
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConTimeOutMillis(1000).setReadTimeOutMillis(3000).build();
        }

        protected Logger assignLogger() {
            return LOGGER;
        }
    }
}

