/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.ai.utils.McpConfigUtils;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Service;

@Service
public class McpToolOperationService {
    private final ConfigQueryChainService configQueryChainService;
    private final ConfigOperationService configOperationService;

    public McpToolOperationService(ConfigQueryChainService configQueryChainService, ConfigOperationService configOperationService) {
        this.configQueryChainService = configQueryChainService;
        this.configOperationService = configOperationService;
    }

    public void refreshMcpTool(String namespaceId, McpServerBasicInfo serverBasicInfo, McpToolSpecification toolSpecification) throws NacosException {
        ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
        ConfigFormV3 toolConfigForm = this.buildMcpToolConfigForm(namespaceId, serverBasicInfo, toolSpecification);
        this.configOperationService.publishConfig((ConfigForm)toolConfigForm, configRequestInfo, null);
    }

    public McpToolSpecification getMcpTool(String namespaceId, String toolsDescriptionRef) {
        ConfigQueryChainRequest request = this.buildQueryMcpToolRequest(namespaceId, toolsDescriptionRef);
        ConfigQueryChainResponse response = this.configQueryChainService.handle(request);
        if (ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_NOT_FOUND == response.getStatus()) {
            return null;
        }
        return this.transferToMcpServerTool(response);
    }

    public void deleteMcpTool(String namespaceId, String mcpServerId, String version) throws NacosException {
        this.configOperationService.deleteConfig(McpConfigUtils.formatServerToolSpecDataId(mcpServerId, version), "mcp-tools", namespaceId, null, null, "nacos", null);
    }

    private ConfigFormV3 buildMcpToolConfigForm(String namespaceId, McpServerBasicInfo mcpServerBasicInfo, McpToolSpecification toolSpecification) {
        ConfigFormV3 configFormV3 = new ConfigFormV3();
        configFormV3.setGroupName("mcp-tools");
        configFormV3.setGroup("mcp-tools");
        configFormV3.setNamespaceId(namespaceId);
        String toolSpecDataId = McpConfigUtils.formatServerToolSpecDataId(mcpServerBasicInfo.getId(), mcpServerBasicInfo.getVersionDetail().getVersion());
        configFormV3.setDataId(toolSpecDataId);
        configFormV3.setContent(JacksonUtils.toJson((Object)toolSpecification));
        configFormV3.setType(ConfigType.JSON.getType());
        configFormV3.setAppName(mcpServerBasicInfo.getName());
        configFormV3.setSrcUser("nacos");
        configFormV3.setConfigTags("nacos.internal.config=mcp");
        return configFormV3;
    }

    private ConfigQueryChainRequest buildQueryMcpToolRequest(String namespaceId, String toolsDescriptionRef) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setDataId(toolsDescriptionRef);
        request.setGroup("mcp-tools");
        request.setTenant(namespaceId);
        return request;
    }

    private McpToolSpecification transferToMcpServerTool(ConfigQueryChainResponse response) {
        return (McpToolSpecification)JacksonUtils.toObj((String)response.getContent(), (TypeReference)new TypeReference<McpToolSpecification>(){});
    }
}

