/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.ai.service;

import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.core.ServiceOperator;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class McpEndpointOperationService {
    private final ServiceOperator serviceOperator;
    private final InstanceOperator instanceOperator;
    private final NamingMetadataManager metadataManager;

    public McpEndpointOperationService(ServiceOperator serviceOperator, InstanceOperator instanceOperator, NamingMetadataManager metadataManager) {
        this.serviceOperator = serviceOperator;
        this.instanceOperator = instanceOperator;
        this.metadataManager = metadataManager;
    }

    public com.alibaba.nacos.naming.core.v2.pojo.Service createMcpServerEndpointServiceIfNecessary(String namespaceId, String mcpName, McpEndpointSpec endpointSpecification) throws NacosException {
        if ("REF".equalsIgnoreCase(endpointSpecification.getType())) {
            Map endpointServiceData = endpointSpecification.getData();
            if (!(endpointServiceData.containsKey("namespaceId") && endpointServiceData.containsKey("groupName") && endpointServiceData.containsKey("serviceName"))) {
                throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "`namespaceId`, `groupName`, `serviceName` should be in remoteServerConfig data if type is `REF`");
            }
            String refGroupName = (String)endpointSpecification.getData().get("groupName");
            String refServiceName = (String)endpointSpecification.getData().get("serviceName");
            return com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)namespaceId, (String)refGroupName, (String)refServiceName);
        }
        com.alibaba.nacos.naming.core.v2.pojo.Service service = com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)namespaceId, (String)"mcp-endpoints", (String)mcpName);
        if (this.isNotExist(service)) {
            this.doCreateNewService(service);
            this.doUpdateInstanceInfo(service, endpointSpecification);
            return service;
        }
        this.doUpdateInstanceInfo(service, endpointSpecification);
        return service;
    }

    public List<Instance> getMcpServerEndpointInstances(McpServiceRef serviceRef) throws NacosException {
        return this.instanceOperator.listInstance(serviceRef.getNamespaceId(), serviceRef.getGroupName(), serviceRef.getServiceName(), null, "", true).getHosts();
    }

    public void deleteMcpServerEndpointService(String namespaceId, String mcpServerName) throws NacosException {
        com.alibaba.nacos.naming.core.v2.pojo.Service service = com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)namespaceId, (String)"mcp-endpoints", (String)mcpServerName);
        if (this.isNotExist(service) || !this.isMcpDirectService(service)) {
            return;
        }
        List deletingInstance = this.instanceOperator.listInstance(namespaceId, "mcp-endpoints", mcpServerName, null, "", false).getHosts();
        for (Instance each : deletingInstance) {
            this.instanceOperator.removeInstance(namespaceId, "mcp-endpoints", mcpServerName, each);
        }
        this.serviceOperator.delete(service.getNamespace(), service.getGroupedServiceName());
    }

    private boolean isNotExist(com.alibaba.nacos.naming.core.v2.pojo.Service service) throws NacosException {
        return !ServiceManager.getInstance().containSingleton(service);
    }

    private boolean isMcpDirectService(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        ServiceMetadata metadata = this.metadataManager.getServiceMetadata(service).orElse(new ServiceMetadata());
        return metadata.getExtendData().containsKey("__nacos.ai.mcp.service__");
    }

    private void doCreateNewService(com.alibaba.nacos.naming.core.v2.pojo.Service service) throws NacosException {
        ClusterMetadata clusterMetadata = new ClusterMetadata();
        clusterMetadata.setHealthyCheckType("NONE");
        clusterMetadata.setHealthChecker((AbstractHealthChecker)new AbstractHealthChecker.None());
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.getClusters().put("DEFAULT", clusterMetadata);
        serviceMetadata.setEphemeral(false);
        serviceMetadata.getExtendData().put("__nacos.ai.mcp.service__", "true");
        this.serviceOperator.create(service.getNamespace(), service.getGroupedServiceName(), serviceMetadata);
    }

    private void doUpdateInstanceInfo(com.alibaba.nacos.naming.core.v2.pojo.Service service, McpEndpointSpec endpointSpecification) throws NacosException {
        Instance instance = new Instance();
        instance.setIp((String)endpointSpecification.getData().get("address"));
        instance.setPort(Integer.parseInt((String)endpointSpecification.getData().get("port")));
        instance.setClusterName("DEFAULT");
        instance.setEphemeral(false);
        this.instanceOperator.registerInstance(service.getNamespace(), service.getGroup(), service.getName(), instance);
    }
}

