/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import com.alibaba.nacos.sys.file.WatchFileCenter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RemoteServerUtil {
    private static List<String> serverAddresses = new LinkedList<String>();
    private static AtomicInteger index = new AtomicInteger();
    private static String remoteServerContextPath = "/nacos";

    private static void initRemoteServerContextPath() {
        remoteServerContextPath = EnvUtil.getProperty((String)"nacos.console.remote.server.context-path", (String)"/nacos");
    }

    private static void registerWatcher() {
        try {
            WatchFileCenter.registerWatcher((String)EnvUtil.getClusterConfFilePath(), (FileWatcher)new FileWatcher(){

                public void onChange(FileChangeEvent event) {
                    RemoteServerUtil.readRemoteServerAddress();
                }

                public boolean interest(String context) {
                    return true;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void readRemoteServerAddress() {
        try {
            serverAddresses = EnvUtil.readClusterConf();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<String> getServerAddresses() {
        return new LinkedList<String>(serverAddresses);
    }

    public static String getOneNacosServerAddress() {
        int actual = index.getAndUpdate(operand -> (operand + 1) % serverAddresses.size());
        return serverAddresses.get(actual);
    }

    public static String getRemoteServerContextPath() {
        return remoteServerContextPath;
    }

    public static void singleCheckResult(HttpRestResult<String> result) throws NacosException {
        if (result.ok()) {
            return;
        }
        throw new NacosException(result.getCode(), result.getMessage());
    }

    public static Header buildServerRemoteHeader(AuthConfigs authConfigs) {
        Header header = Header.newInstance();
        if (StringUtils.isNotBlank((String)authConfigs.getServerIdentityKey())) {
            header.addParam(authConfigs.getServerIdentityKey(), authConfigs.getServerIdentityValue());
        }
        return header;
    }

    static {
        RemoteServerUtil.readRemoteServerAddress();
        RemoteServerUtil.registerWatcher();
        RemoteServerUtil.initRemoteServerContextPath();
    }
}

