/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.users;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.DefaultHttpClientFactory;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.users.AbstractCachedUserService;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetails;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import com.alibaba.nacos.plugin.auth.impl.utils.RemoteServerUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class NacosUserServiceRemoteImpl
extends AbstractCachedUserService
implements NacosUserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosUserServiceRemoteImpl.class);
    private final NacosRestTemplate nacosRestTemplate;
    private final AuthConfigs authConfigs;

    public NacosUserServiceRemoteImpl(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
        this.nacosRestTemplate = new DefaultHttpClientFactory(LOGGER).createNacosRestTemplate();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.getUser(username);
        if (null == user) {
            throw new UsernameNotFoundException(String.format("User %s not found", username));
        }
        return new NacosUserDetails(user);
    }

    @Override
    public void updateUserPassword(String username, String password) {
        Query query = Query.newInstance().addParam("username", (Object)username);
        Map<String, String> body = Map.of("newPassword", password);
        try {
            HttpRestResult result = this.nacosRestTemplate.putForm(this.buildRemoteUserUrlPath("/v3/auth/user"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, body, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public Page<User> getUsers(int pageNo, int pageSize, String username) {
        Query query = Query.newInstance().addParam("username", (Object)username).addParam("pageNo", (Object)pageNo).addParam("pageSize", (Object)pageSize).addParam("search", (Object)"accurate");
        return this.getUserPageFromRemote(query);
    }

    @Override
    public Page<User> findUsers(String username, int pageNo, int pageSize) {
        Query query = Query.newInstance().addParam("username", (Object)username).addParam("pageNo", (Object)pageNo).addParam("pageSize", (Object)pageSize).addParam("search", (Object)"blur");
        return this.getUserPageFromRemote(query);
    }

    @Override
    public User getUser(String username) {
        if (this.getCachedUserMap().containsKey(username)) {
            return this.getCachedUserMap().get(username);
        }
        this.reload();
        return this.getCachedUserMap().get(username);
    }

    @Override
    public List<String> findUserNames(String username) {
        Query query = Query.newInstance().addParam("username", (Object)username);
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(this.buildRemoteUserUrlPath("/v3/auth/user/search"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)httpResult);
            Result result = (Result)JacksonUtils.toObj((String)((String)httpResult.getData()), (TypeReference)new TypeReference<Result<List<String>>>(){});
            return (List)result.getData();
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public void createUser(String username, String password, boolean encode) {
        if ("nacos".equals(username)) {
            this.doCreateAdminUser(password);
            return;
        }
        Query query = Query.newInstance().addParam("username", (Object)username);
        Map<String, String> body = Map.of("password", password);
        try {
            HttpRestResult result = this.nacosRestTemplate.postForm(this.buildRemoteUserUrlPath("/v3/auth/user"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, body, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    private void doCreateAdminUser(String password) {
        Map<String, String> body = Map.of("password", password);
        try {
            HttpRestResult result = this.nacosRestTemplate.postForm(this.buildRemoteUserUrlPath("/v3/auth/user/admin"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), Query.newInstance(), body, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public void deleteUser(String username) {
        Query query = Query.newInstance().addParam("username", (Object)username);
        try {
            HttpRestResult result = this.nacosRestTemplate.delete(this.buildRemoteUserUrlPath("/v3/auth/user"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    private String buildRemoteUserUrlPath(String apiPath) {
        return "http://" + RemoteServerUtil.getOneNacosServerAddress() + RemoteServerUtil.getRemoteServerContextPath() + apiPath;
    }

    private Page<User> getUserPageFromRemote(Query query) {
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(this.buildRemoteUserUrlPath("/v3/auth/user/list"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)httpResult);
            Result result = (Result)JacksonUtils.toObj((String)((String)httpResult.getData()), (TypeReference)new TypeReference<Result<Page<User>>>(){});
            return (Page)result.getData();
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }
}

