/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller.v3;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/auth/role"})
public class RoleControllerV3 {
    private final NacosRoleService roleService;
    private static final String SEARCH_TYPE_BLUR = "blur";

    public RoleControllerV3(NacosRoleService roleService) {
        this.roleService = roleService;
    }

    @PostMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    public Result<String> createRole(@RequestParam String role, @RequestParam String username) {
        this.roleService.addRole(role, username);
        return Result.success((Object)"add role ok!");
    }

    @DeleteMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    public Result<String> deleteRole(@RequestParam String role, @RequestParam(name="username", defaultValue="") String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            this.roleService.deleteRole(role);
        } else {
            this.roleService.deleteRole(role, username);
        }
        return Result.success((Object)("delete role of user " + username + " ok!"));
    }

    @GetMapping(value={"/list"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public Result<Page<RoleInfo>> getRoleList(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", defaultValue="") String username, @RequestParam(name="role", defaultValue="") String role, @RequestParam(name="search", required=false, defaultValue="accurate") String search) {
        Page<RoleInfo> rolePage = SEARCH_TYPE_BLUR.equalsIgnoreCase(search) ? this.roleService.findRoles(username, role, pageNo, pageSize) : this.roleService.getRoles(username, role, pageNo, pageSize);
        return Result.success(rolePage);
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public Result<List<String>> getRoleListByRoleName(@RequestParam String role) {
        List<String> roles = this.roleService.findRoleNames(role);
        return Result.success(roles);
    }
}

