/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller.v3;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/auth/permission"})
public class PermissionControllerV3 {
    private final NacosRoleService nacosRoleService;
    private static final String SEARCH_TYPE_BLUR = "blur";

    @Autowired
    public PermissionControllerV3(NacosRoleService nacosRoleService) {
        this.nacosRoleService = nacosRoleService;
    }

    @PostMapping
    @Secured(resource="console/permissions", action=ActionTypes.WRITE)
    public Result<String> createPermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        this.nacosRoleService.addPermission(role, resource, action);
        return Result.success((Object)"add permission ok!");
    }

    @DeleteMapping
    @Secured(resource="console/permissions", action=ActionTypes.WRITE)
    public Result<String> deletePermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        this.nacosRoleService.deletePermission(role, resource, action);
        return Result.success((Object)"delete permission ok!");
    }

    @GetMapping(value={"/list"})
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    public Result<Page<PermissionInfo>> getPermissionList(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="role", defaultValue="") String role, @RequestParam(name="search", defaultValue="accurate") String search) {
        Page<PermissionInfo> permissionPage = SEARCH_TYPE_BLUR.equalsIgnoreCase(search) ? this.nacosRoleService.findPermissions(role, pageNo, pageSize) : this.nacosRoleService.getPermissions(role, pageNo, pageSize);
        return Result.success(permissionPage);
    }

    @GetMapping
    @Secured(resource="console/permissions", action=ActionTypes.READ)
    public Result<Boolean> isDuplicatePermission(@RequestParam String role, @RequestParam String resource, @RequestParam String action) {
        return this.nacosRoleService.isDuplicatePermission(role, resource, action);
    }
}

