/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.authenticate;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManagerDelegate;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetails;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordEncoderUtil;
import jakarta.servlet.http.HttpServletRequest;

public class AbstractAuthenticationManager
implements IAuthenticationManager {
    private static final String USER_NOT_FOUND_MESSAGE = "User not found! Please check user exist or password is right!";
    protected NacosUserService userDetailsService;
    protected TokenManagerDelegate jwtTokenManager;
    protected NacosRoleService roleService;

    public AbstractAuthenticationManager(NacosUserService userDetailsService, TokenManagerDelegate jwtTokenManager, NacosRoleService roleService) {
        this.userDetailsService = userDetailsService;
        this.jwtTokenManager = jwtTokenManager;
        this.roleService = roleService;
    }

    @Override
    public NacosUser authenticate(String username, String rawPassword) throws AccessException {
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)rawPassword)) {
            throw new AccessException(USER_NOT_FOUND_MESSAGE);
        }
        NacosUserDetails nacosUserDetails = (NacosUserDetails)this.userDetailsService.loadUserByUsername(username);
        if (nacosUserDetails == null || !PasswordEncoderUtil.matches(rawPassword, nacosUserDetails.getPassword()).booleanValue()) {
            throw new AccessException(USER_NOT_FOUND_MESSAGE);
        }
        return new NacosUser(nacosUserDetails.getUsername(), this.jwtTokenManager.createToken(username));
    }

    @Override
    public NacosUser authenticate(String token) throws AccessException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AccessException(USER_NOT_FOUND_MESSAGE);
        }
        return this.jwtTokenManager.parseToken(token);
    }

    @Override
    public NacosUser authenticate(HttpServletRequest httpServletRequest) throws AccessException {
        NacosUser user;
        String token = this.resolveToken(httpServletRequest);
        if (StringUtils.isNotBlank((String)token)) {
            user = this.authenticate(token);
        } else {
            String userName = httpServletRequest.getParameter("username");
            String password = httpServletRequest.getParameter("password");
            user = this.authenticate(userName, password);
        }
        return user;
    }

    @Override
    public void authorize(Permission permission, NacosUser nacosUser) throws AccessException {
        if (Loggers.AUTH.isDebugEnabled()) {
            Loggers.AUTH.debug("auth permission: {}, nacosUser: {}", (Object)permission, (Object)nacosUser);
        }
        if (nacosUser.isGlobalAdmin()) {
            return;
        }
        if (this.hasGlobalAdminRole(nacosUser)) {
            return;
        }
        if (!this.roleService.hasPermission(nacosUser, permission)) {
            throw new AccessException("authorization failed!");
        }
    }

    private String resolveToken(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring("Bearer ".length());
        }
        bearerToken = request.getParameter("accessToken");
        return bearerToken;
    }

    @Override
    public boolean hasGlobalAdminRole(String username) {
        return this.roleService.hasGlobalAdminRole(username);
    }

    @Override
    public boolean hasGlobalAdminRole() {
        return this.roleService.hasGlobalAdminRole();
    }

    @Override
    public boolean hasGlobalAdminRole(NacosUser nacosUser) {
        if (nacosUser.isGlobalAdmin()) {
            return true;
        }
        nacosUser.setGlobalAdmin(this.hasGlobalAdminRole(nacosUser.getUserName()));
        return nacosUser.isGlobalAdmin();
    }
}

