/*
 * Decompiled with CFR 0.152.
 */
package io.agora.media;

import io.agora.media.DynamicKeyUtil;
import java.io.ByteArrayOutputStream;

public class DynamicKey {
    public static String generate(String appID, String appCertificate, String channelName, int unixTs, int randomInt) throws Exception {
        String unixTsStr = ("0000000000" + Integer.toString(unixTs)).substring(Integer.toString(unixTs).length());
        String randomIntStr = ("00000000" + Integer.toHexString(randomInt)).substring(Integer.toHexString(randomInt).length());
        String signature = DynamicKey.generateSignature(appID, appCertificate, channelName, unixTsStr, randomIntStr);
        return String.format("%s%s%s%s", signature, appID, unixTsStr, randomIntStr);
    }

    private static String generateSignature(String appID, String appCertificate, String channelName, String unixTsStr, String randomIntStr) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(appID.getBytes());
        baos.write(unixTsStr.getBytes());
        baos.write(randomIntStr.getBytes());
        baos.write(channelName.getBytes());
        byte[] sign = DynamicKeyUtil.encodeHMAC(appCertificate, baos.toByteArray());
        return DynamicKeyUtil.bytesToHex(sign);
    }
}

