/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.http.converter;

import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OidcClientRegistrationHttpMessageConverter
extends AbstractHttpMessageConverter<OidcClientRegistration> {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    private Converter<Map<String, Object>, OidcClientRegistration> clientRegistrationConverter = new MapOidcClientRegistrationConverter();
    private Converter<OidcClientRegistration, Map<String, Object>> clientRegistrationParametersConverter = new OidcClientRegistrationMapConverter();

    public OidcClientRegistrationHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OidcClientRegistration.class.isAssignableFrom(clazz);
    }

    protected OidcClientRegistration readInternal(Class<? extends OidcClientRegistration> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map clientRegistrationParameters = (Map)this.jsonMessageConverter.read(STRING_OBJECT_MAP.getType(), null, inputMessage);
            return (OidcClientRegistration)this.clientRegistrationConverter.convert((Object)clientRegistrationParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the OpenID Client Registration: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OidcClientRegistration clientRegistration, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map clientRegistrationParameters = (Map)this.clientRegistrationParametersConverter.convert((Object)clientRegistration);
            this.jsonMessageConverter.write((Object)clientRegistrationParameters, STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OpenID Client Registration: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setClientRegistrationConverter(Converter<Map<String, Object>, OidcClientRegistration> clientRegistrationConverter) {
        Assert.notNull(clientRegistrationConverter, (String)"clientRegistrationConverter cannot be null");
        this.clientRegistrationConverter = clientRegistrationConverter;
    }

    public final void setClientRegistrationParametersConverter(Converter<OidcClientRegistration, Map<String, Object>> clientRegistrationParametersConverter) {
        Assert.notNull(clientRegistrationParametersConverter, (String)"clientRegistrationParametersConverter cannot be null");
        this.clientRegistrationParametersConverter = clientRegistrationParametersConverter;
    }

    private static final class OidcClientRegistrationMapConverter
    implements Converter<OidcClientRegistration, Map<String, Object>> {
        private OidcClientRegistrationMapConverter() {
        }

        public Map<String, Object> convert(OidcClientRegistration source) {
            LinkedHashMap<String, Object> responseClaims = new LinkedHashMap<String, Object>(source.getClaims());
            if (source.getClientIdIssuedAt() != null) {
                responseClaims.put("client_id_issued_at", source.getClientIdIssuedAt().getEpochSecond());
            }
            if (source.getClientSecret() != null) {
                long clientSecretExpiresAt = 0L;
                if (source.getClientSecretExpiresAt() != null) {
                    clientSecretExpiresAt = source.getClientSecretExpiresAt().getEpochSecond();
                }
                responseClaims.put("client_secret_expires_at", clientSecretExpiresAt);
            }
            if (!CollectionUtils.isEmpty(source.getScopes())) {
                responseClaims.put("scope", StringUtils.collectionToDelimitedString(source.getScopes(), (String)" "));
            }
            return responseClaims;
        }
    }

    private static final class MapOidcClientRegistrationConverter
    implements Converter<Map<String, Object>, OidcClientRegistration> {
        private static final ClaimConversionService CLAIM_CONVERSION_SERVICE = ClaimConversionService.getSharedInstance();
        private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
        private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private static final TypeDescriptor INSTANT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Instant.class);
        private static final TypeDescriptor URL_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(URL.class);
        private static final Converter<Object, ?> INSTANT_CONVERTER = MapOidcClientRegistrationConverter.getConverter(INSTANT_TYPE_DESCRIPTOR);
        private final ClaimTypeConverter claimTypeConverter;

        private MapOidcClientRegistrationConverter() {
            Converter<Object, ?> stringConverter = MapOidcClientRegistrationConverter.getConverter(STRING_TYPE_DESCRIPTOR);
            Converter<Object, ?> collectionStringConverter = MapOidcClientRegistrationConverter.getConverter(TypeDescriptor.collection(Collection.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR));
            Converter<Object, ?> urlConverter = MapOidcClientRegistrationConverter.getConverter(URL_TYPE_DESCRIPTOR);
            HashMap<String, Object> claimConverters = new HashMap<String, Object>();
            claimConverters.put("client_id", stringConverter);
            claimConverters.put("client_id_issued_at", INSTANT_CONVERTER);
            claimConverters.put("client_secret", stringConverter);
            claimConverters.put("client_secret_expires_at", MapOidcClientRegistrationConverter::convertClientSecretExpiresAt);
            claimConverters.put("client_name", stringConverter);
            claimConverters.put("redirect_uris", collectionStringConverter);
            claimConverters.put("token_endpoint_auth_method", stringConverter);
            claimConverters.put("token_endpoint_auth_signing_alg", stringConverter);
            claimConverters.put("grant_types", collectionStringConverter);
            claimConverters.put("response_types", collectionStringConverter);
            claimConverters.put("scope", MapOidcClientRegistrationConverter::convertScope);
            claimConverters.put("jwks_uri", urlConverter);
            claimConverters.put("id_token_signed_response_alg", stringConverter);
            this.claimTypeConverter = new ClaimTypeConverter(claimConverters);
        }

        public OidcClientRegistration convert(Map<String, Object> source) {
            Map parsedClaims = this.claimTypeConverter.convert(source);
            Object clientSecretExpiresAt = parsedClaims.get("client_secret_expires_at");
            if (clientSecretExpiresAt instanceof Number && clientSecretExpiresAt.equals(0)) {
                parsedClaims.remove("client_secret_expires_at");
            }
            return OidcClientRegistration.withClaims(parsedClaims).build();
        }

        private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
            return source -> CLAIM_CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, targetDescriptor);
        }

        private static Instant convertClientSecretExpiresAt(Object clientSecretExpiresAt) {
            if (clientSecretExpiresAt != null && String.valueOf(clientSecretExpiresAt).equals("0")) {
                return null;
            }
            return (Instant)INSTANT_CONVERTER.convert(clientSecretExpiresAt);
        }

        private static List<String> convertScope(Object scope) {
            if (scope == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(StringUtils.delimitedListToStringArray((String)scope.toString(), (String)" "));
        }
    }
}

