/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc;

import java.net.URL;
import java.time.Instant;
import java.util.List;
import org.springframework.security.oauth2.core.ClaimAccessor;

public interface OidcClientMetadataClaimAccessor
extends ClaimAccessor {
    default public String getClientId() {
        return this.getClaimAsString("client_id");
    }

    default public Instant getClientIdIssuedAt() {
        return this.getClaimAsInstant("client_id_issued_at");
    }

    default public String getClientSecret() {
        return this.getClaimAsString("client_secret");
    }

    default public Instant getClientSecretExpiresAt() {
        return this.getClaimAsInstant("client_secret_expires_at");
    }

    default public String getClientName() {
        return this.getClaimAsString("client_name");
    }

    default public List<String> getRedirectUris() {
        return this.getClaimAsStringList("redirect_uris");
    }

    default public String getTokenEndpointAuthenticationMethod() {
        return this.getClaimAsString("token_endpoint_auth_method");
    }

    default public String getTokenEndpointAuthenticationSigningAlgorithm() {
        return this.getClaimAsString("token_endpoint_auth_signing_alg");
    }

    default public List<String> getGrantTypes() {
        return this.getClaimAsStringList("grant_types");
    }

    default public List<String> getResponseTypes() {
        return this.getClaimAsStringList("response_types");
    }

    default public List<String> getScopes() {
        return this.getClaimAsStringList("scope");
    }

    default public URL getJwkSetUrl() {
        return this.getClaimAsURL("jwks_uri");
    }

    default public String getIdTokenSignedResponseAlgorithm() {
        return this.getClaimAsString("id_token_signed_response_alg");
    }

    default public String getRegistrationAccessToken() {
        return this.getClaimAsString("registration_access_token");
    }

    default public URL getRegistrationClientUrl() {
        return this.getClaimAsURL("registration_client_uri");
    }
}

