/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.redisson.api.search.index.IndexInfo;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class IndexInfoDecoder
implements MultiDecoder<Object> {
    @Override
    public Object decode(List<Object> parts, State state) {
        if (!parts.isEmpty() && parts.get(0) instanceof Map) {
            return parts;
        }
        LinkedHashMap<String, Object> result = MultiDecoder.newLinkedHashMap(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put((String)parts.get(i - 1), parts.get(i));
        }
        if (state.getLevel() == 0) {
            IndexInfo ii = new IndexInfo();
            ii.setName((String)result.get("index_name"));
            ii.setOptions((Map)result.get("index_options"));
            ii.setDefinition((Map)result.get("index_definition"));
            ii.setAttributes((List)result.get("attributes"));
            ii.setDocs(this.toLong(result, "num_docs"));
            ii.setMaxDocId(this.toLong(result, "max_doc_id"));
            ii.setTerms(this.toLong(result, "num_terms"));
            ii.setRecords(this.toLong(result, "num_records"));
            ii.setInvertedSize(this.toDouble(result, "inverted_sz_mb"));
            ii.setVectorIndexSize(this.toDouble(result, "vector_index_sz_mb"));
            ii.setTotalInvertedIndexBlocks(this.toDouble(result, "total_inverted_index_blocks"));
            ii.setOffsetVectorsSize(this.toDouble(result, "offset_vectors_sz_mb"));
            ii.setDocTableSize(this.toDouble(result, "doc_table_size_mb"));
            ii.setSortableValuesSize(this.toDouble(result, "sortable_values_size_mb"));
            ii.setKeyTableSize(this.toDouble(result, "key_table_size_mb"));
            ii.setRecordsPerDocAverage(this.toDouble(result, "records_per_doc_avg"));
            ii.setBytesPerRecordAverage(this.toDouble(result, "bytes_per_record_avg"));
            ii.setOffsetsPerTermAverage(this.toDouble(result, "offsets_per_term_avg"));
            ii.setOffsetBitsPerRecordAverage(this.toDouble(result, "offset_bits_per_record_avg"));
            ii.setHashIndexingFailures(this.toLong(result, "hash_indexing_failures"));
            ii.setTotalIndexingTime(this.toDouble(result, "total_indexing_time"));
            ii.setIndexing(this.toLong(result, "indexing"));
            ii.setPercentIndexed(this.toDouble(result, "percent_indexed"));
            ii.setNumberOfUses(this.toLong(result, "number_of_uses"));
            ii.setGcStats((Map)result.get("gc_stats"));
            ii.setCursorStats((Map)result.get("cursor_stats"));
            ii.setDialectStats((Map)result.get("dialect_stats"));
            return ii;
        }
        return result;
    }

    private Long toLong(Map<String, Object> result, String prop) {
        if (result.get(prop).toString().contains("nan")) {
            return 0L;
        }
        if (result.get(prop) instanceof Double) {
            Double d = (Double)result.get(prop);
            return d.longValue();
        }
        return Long.valueOf(result.get(prop).toString());
    }

    private Double toDouble(Map<String, Object> result, String prop) {
        if (result.get(prop).toString().contains("nan")) {
            return 0.0;
        }
        return Double.valueOf(result.get(prop).toString());
    }
}

