/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Internal;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Alias;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

@Internal
public class TableImpl<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = 261033315221985068L;
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Set<SQLDialect> NO_SUPPORT_QUALIFIED_TVF_CALLS = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> REQUIRES_TVF_TABLE_CONSTRUCTOR = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    final Fields<R> fields = new Fields(new Field[0]);
    final Alias<Table<R>> alias;
    protected final Field<?>[] parameters;
    final Table<?> child;
    final ForeignKey<?, R> childPath;

    @Deprecated
    public TableImpl(String name) {
        this(DSL.name(name));
    }

    @Deprecated
    public TableImpl(String name, Schema schema) {
        this(DSL.name(name), schema);
    }

    @Deprecated
    public TableImpl(String name, Schema schema, Table<R> aliased) {
        this(DSL.name(name), schema, aliased);
    }

    @Deprecated
    public TableImpl(String name, Schema schema, Table<R> aliased, Field<?>[] parameters) {
        this(DSL.name(name), schema, aliased, parameters);
    }

    @Deprecated
    public TableImpl(String name, Schema schema, Table<R> aliased, Field<?>[] parameters, String comment) {
        this(DSL.name(name), schema, aliased, parameters, comment);
    }

    public TableImpl(Name name) {
        this(name, null, null, null, null, null, null);
    }

    public TableImpl(Name name, Schema schema) {
        this(name, schema, null, null, null, null, null);
    }

    public TableImpl(Name name, Schema schema, Table<R> aliased) {
        this(name, schema, null, null, aliased, null, null);
    }

    public TableImpl(Name name, Schema schema, Table<R> aliased, Field<?>[] parameters) {
        this(name, schema, null, null, aliased, parameters, null);
    }

    @Deprecated
    public TableImpl(Name name, Schema schema, Table<R> aliased, Field<?>[] parameters, String comment) {
        this(name, schema, null, null, aliased, parameters, DSL.comment(comment));
    }

    public TableImpl(Name name, Schema schema, Table<R> aliased, Field<?>[] parameters, Comment comment) {
        this(name, schema, null, null, aliased, parameters, comment);
    }

    public TableImpl(Name name, Schema schema, Table<R> aliased, Field<?>[] parameters, Comment comment, TableOptions options) {
        this(name, schema, null, null, aliased, parameters, comment, options);
    }

    public TableImpl(Table<?> child, ForeignKey<?, R> path, Table<R> parent) {
        this(org.jooq.impl.Internal.createPathAlias(child, path), null, child, path, parent, null, parent.getCommentPart());
    }

    public TableImpl(Name name, Schema schema, Table<?> child, ForeignKey<?, R> path, Table<R> aliased, Field<?>[] parameters, Comment comment) {
        this(name, schema, child, path, aliased, parameters, comment, TableOptions.table());
    }

    public TableImpl(Name name, Schema schema, Table<?> child, ForeignKey<?, R> path, Table<R> aliased, Field<?>[] parameters, Comment comment, TableOptions options) {
        super(options, name, schema, comment);
        Alias<Table<R>> existingAlias;
        if (child != null) {
            this.child = child;
            this.childPath = path == null ? null : Tools.aliasedKey(path, child, this);
        } else if (aliased instanceof TableImpl) {
            this.child = ((TableImpl)aliased).child;
            this.childPath = ((TableImpl)aliased).childPath;
        } else {
            this.child = null;
            this.childPath = null;
        }
        this.alias = aliased != null ? ((existingAlias = Tools.alias(aliased)) != null ? new Alias<TableImpl>((TableImpl)existingAlias.wrapped, this, name, existingAlias.fieldAliases, existingAlias.wrapInParentheses) : new Alias<TableImpl>((TableImpl)aliased, this, name)) : null;
        this.parameters = parameters;
    }

    Table<R> getAliasedTable() {
        if (this.alias != null) {
            return this.alias.wrapped();
        }
        return null;
    }

    @Internal
    protected boolean aliased() {
        return this.getAliasedTable() != null;
    }

    @Override
    final Fields<R> fields0() {
        return this.fields;
    }

    @Override
    public Row fieldsRow() {
        return super.fieldsRow();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.alias != null ? CLAUSES_TABLE_ALIAS : CLAUSES_TABLE_REFERENCE;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.child != null) {
            ctx.scopeRegister(this);
        }
        if (this.alias != null) {
            ctx.visit(this.alias);
        } else if (this.parameters != null && REQUIRES_TVF_TABLE_CONSTRUCTOR.contains((Object)ctx.dialect()) && ctx.declareTables()) {
            ctx.visit(Keywords.K_TABLE).sql('(');
            this.accept0(ctx);
            ctx.sql(')');
            if (ctx.declareAliases()) {
                ctx.sql(' ').visit(Tools.getMappedTable(ctx.configuration(), this).getUnqualifiedName());
            }
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        Schema mappedSchema;
        if (ctx.declareTables()) {
            ctx.scopeMarkStart(this);
        }
        if (ctx.qualify() && (!NO_SUPPORT_QUALIFIED_TVF_CALLS.contains((Object)ctx.dialect()) || this.parameters == null || ctx.declareTables()) && (mappedSchema = Tools.getMappedSchema(ctx.configuration(), this.getSchema())) != null && !"".equals(mappedSchema.getName())) {
            ctx.visit(mappedSchema);
            ctx.sql('.');
        }
        ctx.visit(Tools.getMappedTable(ctx.configuration(), this).getUnqualifiedName());
        if (this.parameters != null && ctx.declareTables()) {
            if (ctx.family() == SQLDialect.FIREBIRD && this.parameters.length == 0) {
                ctx.visit(QueryPartListView.wrap((QueryPart[])this.parameters));
            } else {
                ctx.sql('(').visit(QueryPartListView.wrap((QueryPart[])this.parameters)).sql(')');
            }
        }
        if (ctx.declareTables()) {
            ctx.scopeMarkEnd(this);
        }
    }

    @Override
    public Table<R> as(Name as) {
        if (this.alias != null) {
            return this.alias.wrapped().as(as);
        }
        return new TableAlias(this, as);
    }

    @Override
    public Table<R> as(Name as, Name ... fieldAliases) {
        if (this.alias != null) {
            return this.alias.wrapped().as(as, fieldAliases);
        }
        return new TableAlias(this, as, fieldAliases);
    }

    public Table<R> rename(String rename) {
        return new TableImpl<R>(rename, this.getSchema());
    }

    public Table<R> rename(Name rename) {
        return new TableImpl<R>(rename, this.getSchema());
    }

    @Override
    public Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public boolean declaresTables() {
        return true;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TableImpl) {
            TableImpl other = (TableImpl)that;
            return StringUtils.equals(StringUtils.defaultIfNull(this.getSchema(), SchemaImpl.DEFAULT_SCHEMA), StringUtils.defaultIfNull(other.getSchema(), SchemaImpl.DEFAULT_SCHEMA)) && StringUtils.equals(this.getName(), other.getName()) && Arrays.equals(this.parameters, other.parameters);
        }
        return super.equals(that);
    }
}

