/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Blob;
import java.sql.SQLException;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.jdbc.JDBCUtils;

public class BlobBinding
implements Binding<byte[], byte[]> {
    private static final long serialVersionUID = 358789452467943117L;

    @Override
    public final Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    @Override
    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        ctx.render().visit(DSL.val((Object)ctx.value(), SQLDataType.BLOB));
    }

    @Override
    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 2004);
    }

    @Override
    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        ctx.statement().setBlob(ctx.index(), ctx.autoFree(this.newBlob(ctx.configuration(), ctx.value())));
    }

    @Override
    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        ctx.output().writeBlob(ctx.autoFree(this.newBlob(ctx.configuration(), ctx.value())));
    }

    @Override
    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.resultSet().getBlob(ctx.index());
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    @Override
    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.statement().getBlob(ctx.index());
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.input().readBlob();
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    private final Blob newBlob(Configuration configuration, byte[] bytes) throws SQLException {
        switch (configuration.family()) {
            default: 
        }
        Blob blob = DefaultExecuteContext.localConnection().createBlob();
        blob.setBytes(1L, bytes);
        return blob;
    }
}

