/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteType;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.RenderContext;
import org.jooq.conf.ParamType;
import org.jooq.conf.QueryPoolable;
import org.jooq.conf.SettingsTools;
import org.jooq.conf.ThrowExceptions;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DetachedException;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.ExecutorProviderCompletionStage;
import org.jooq.impl.ParamCollector;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;
import org.jooq.tools.Ints;
import org.jooq.tools.JooqLogger;

abstract class AbstractQuery
extends AbstractQueryPart
implements Query {
    private static final long serialVersionUID = -8046199737354507547L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private Configuration configuration;
    private int timeout;
    private QueryPoolable poolable = QueryPoolable.DEFAULT;
    private boolean keepStatement;
    transient PreparedStatement statement;
    transient int statementExecutionCount;
    transient Rendered rendered;

    AbstractQuery(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    final void toSQLSemiColon(RenderContext ctx) {
    }

    @Override
    public final List<Object> getBindValues() {
        return this.create().extractBindValues(this);
    }

    @Override
    public final Map<String, Param<?>> getParams() {
        return this.create().extractParams(this);
    }

    @Override
    public final Param<?> getParam(String name) {
        return this.create().extractParam(this, name);
    }

    @Override
    public Query bind(String param, Object value) {
        Integer index = Ints.tryParse(param);
        if (index != null) {
            return this.bind(index, value);
        }
        ParamCollector collector = new ParamCollector(this.configuration(), true);
        collector.visit(this);
        List<Param<?>> params = collector.result.get(param);
        if (params == null || params.size() == 0) {
            throw new IllegalArgumentException("No such parameter : " + param);
        }
        for (Param<?> p : params) {
            p.setConverted(value);
            this.closeIfNecessary(p);
        }
        return this;
    }

    @Override
    public Query bind(int index, Object value) {
        Param<?>[] params = this.getParams().values().toArray(Tools.EMPTY_PARAM);
        if (index < 1 || index > params.length) {
            throw new IllegalArgumentException("Index out of range for Query parameters : " + index);
        }
        Param<?> param = params[index - 1];
        param.setConverted(value);
        this.closeIfNecessary(param);
        return this;
    }

    private final void closeIfNecessary(Param<?> param) {
        if (this.keepStatement() && this.statement != null) {
            if (param.isInline()) {
                this.close();
            } else if (SettingsTools.getParamType(this.configuration().settings()) == ParamType.INLINED) {
                this.close();
            }
        }
    }

    @Override
    public Query poolable(boolean p) {
        this.poolable = p ? QueryPoolable.TRUE : QueryPoolable.FALSE;
        return this;
    }

    @Override
    public Query queryTimeout(int t) {
        this.timeout = t;
        return this;
    }

    @Override
    public Query keepStatement(boolean k) {
        this.keepStatement = k;
        return this;
    }

    protected final boolean keepStatement() {
        return this.keepStatement;
    }

    @Override
    public final void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException e) {
                throw Tools.translate(this.rendered.sql, e);
            }
        }
    }

    @Override
    public final void cancel() {
        if (this.statement != null) {
            try {
                this.statement.cancel();
            }
            catch (SQLException e) {
                throw Tools.translate(this.rendered.sql, e);
            }
        }
    }

    @Override
    public final int execute() {
        if (this.isExecutable()) {
            Configuration c = this.configuration();
            DefaultExecuteContext ctx = new DefaultExecuteContext(c, this);
            ExecuteListener listener = ExecuteListeners.get(ctx);
            int result = 0;
            try {
                QueryPoolable p;
                listener.start(ctx);
                if (this.keepStatement() && this.statement != null) {
                    ctx.sql(this.rendered.sql);
                    ctx.statement(this.statement);
                    ctx.connection(c.connectionProvider(), this.statement.getConnection());
                    ctx.withStatementExecutionCount(++this.statementExecutionCount);
                } else {
                    listener.renderStart(ctx);
                    this.rendered = this.getSQL0(ctx);
                    ctx.sql(this.rendered.sql);
                    listener.renderEnd(ctx);
                    this.rendered.sql = ctx.sql();
                    if (ctx.connection() == null) {
                        throw new DetachedException("Cannot execute query. No Connection configured");
                    }
                    listener.prepareStart(ctx);
                    this.prepare(ctx);
                    listener.prepareEnd(ctx);
                    this.statement = ctx.statement();
                }
                int t = SettingsTools.getQueryTimeout(this.timeout, ctx.settings());
                if (t != 0) {
                    ctx.statement().setQueryTimeout(t);
                }
                if ((p = SettingsTools.getQueryPoolable(this.poolable, ctx.settings())) == QueryPoolable.TRUE) {
                    ctx.statement().setPoolable(true);
                } else if (p == QueryPoolable.FALSE) {
                    ctx.statement().setPoolable(false);
                }
                if (SettingsTools.executePreparedStatements(c.settings()) && !Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT))) {
                    listener.bindStart(ctx);
                    if (this.rendered.bindValues != null) {
                        DSL.using(c).bindContext(ctx.statement()).visit(this.rendered.bindValues);
                    }
                    listener.bindEnd(ctx);
                }
                int n = result = this.execute(ctx, listener);
                return n;
            }
            catch (ControlFlowSignal e) {
                throw e;
            }
            catch (RuntimeException e) {
                ctx.exception(e);
                listener.exception(ctx);
                throw ctx.exception();
            }
            catch (SQLException e) {
                ctx.sqlException(e);
                listener.exception(ctx);
                throw ctx.exception();
            }
            finally {
                if (!this.keepResultSet() || ctx.exception() != null) {
                    Tools.safeClose(listener, ctx, this.keepStatement());
                }
                if (!this.keepStatement()) {
                    this.statement = null;
                    this.rendered = null;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Query is not executable", this);
        }
        return 0;
    }

    @Override
    public final CompletionStage<Integer> executeAsync() {
        return this.executeAsync(Tools.configuration(this).executorProvider().provide());
    }

    @Override
    public final CompletionStage<Integer> executeAsync(Executor executor) {
        return ExecutorProviderCompletionStage.of(CompletableFuture.supplyAsync(Tools.blocking(this::execute), executor), () -> executor);
    }

    protected boolean keepResultSet() {
        return false;
    }

    protected void prepare(ExecuteContext ctx) throws SQLException {
        if (ctx.statement() == null) {
            ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
        }
    }

    protected int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        int result = 0;
        PreparedStatement stmt = ctx.statement();
        try {
            listener.executeStart(ctx);
            if (!stmt.execute()) {
                result = stmt.getUpdateCount();
                ctx.rows(result);
            }
            listener.executeEnd(ctx);
            return result;
        }
        catch (SQLException e) {
            Tools.consumeExceptions(ctx.configuration(), stmt, e);
            if (ctx.settings().getThrowExceptions() != ThrowExceptions.THROW_NONE) {
                throw e;
            }
            return stmt.getUpdateCount();
        }
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    private final Rendered getSQL0(ExecuteContext ctx) {
        Rendered result;
        Configuration c = this.configuration;
        int i = 0;
        while (true) {
            try {
                if (ctx.type() == ExecuteType.DDL) {
                    ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                    DefaultRenderContext render = this.render(c);
                    result = new Rendered(((RenderContext)((RenderContext)render.paramType(ParamType.INLINED)).visit(this)).render(), null, render.peekSkipUpdateCounts());
                    break;
                }
                if (SettingsTools.executePreparedStatements(this.configuration().settings())) {
                    try {
                        DefaultRenderContext render = this.render(c);
                        render.data((Object)Tools.BooleanDataKey.DATA_COUNT_BIND_VALUES, true);
                        result = new Rendered(((RenderContext)render.visit(this)).render(), render.bindValues(), render.peekSkipUpdateCounts());
                    }
                    catch (DefaultRenderContext.ForceInlineSignal e) {
                        ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                        DefaultRenderContext render = this.render(c);
                        result = new Rendered(((RenderContext)((RenderContext)render.paramType(ParamType.INLINED)).visit(this)).render(), null, render.peekSkipUpdateCounts());
                    }
                    break;
                }
                DefaultRenderContext render = this.render(c);
                result = new Rendered(((RenderContext)((RenderContext)render.paramType(ParamType.INLINED)).visit(this)).render(), null, render.peekSkipUpdateCounts());
            }
            catch (DefaultRenderContext.ForceSettingsSignal e) {
                if (++i >= Tools.maxForceSettingsAttempts) {
                    log.warn((Object)"Infinite loop", "There was an infinite loop trying to render a SQL query, due to ForceSettingsSignal. Please consider reporting this bug here: https://github.com/jOOQ/jOOQ/issues/new/choose");
                    throw new DataAccessException("Too many force settings attempts");
                }
                c = c.derive(e.settings);
                continue;
            }
            break;
        }
        return result;
    }

    private final DefaultRenderContext render(Configuration c) {
        DefaultRenderContext render = new DefaultRenderContext(c);
        render.data((Object)Tools.BooleanDataKey.DATA_FORCE_SETTINGS, true);
        return render;
    }

    @Override
    public final String getSQL() {
        return this.getSQL(SettingsTools.getParamType(Tools.settings(this.configuration())));
    }

    @Override
    public final String getSQL(ParamType paramType) {
        switch (paramType) {
            case INDEXED: {
                return this.create().render(this);
            }
            case INLINED: {
                return this.create().renderInlined(this);
            }
            case NAMED: {
                return this.create().renderNamedParams(this);
            }
            case NAMED_OR_INLINED: {
                return this.create().renderNamedOrInlinedParams(this);
            }
            case FORCE_INDEXED: {
                return ((RenderContext)((RenderContext)this.create().renderContext().paramType(paramType)).visit(this)).render();
            }
        }
        throw new IllegalArgumentException("ParamType not supported: " + (Object)((Object)paramType));
    }

    @Override
    @Deprecated
    public final String getSQL(boolean inline) {
        return this.getSQL(inline ? ParamType.INLINED : ParamType.INDEXED);
    }

    static class Rendered {
        String sql;
        QueryPartList<Param<?>> bindValues;
        int skipUpdateCounts;

        Rendered(String sql, QueryPartList<Param<?>> bindValues, int skipUpdateCounts) {
            this.sql = sql;
            this.bindValues = bindValues;
            this.skipUpdateCounts = skipUpdateCounts;
        }

        public String toString() {
            return this.sql;
        }
    }
}

