/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.yaml.swapper;

import java.util.Map;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.yaml.config.YamlTrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.yaml.config.YamlTrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.yaml.swapper.TrafficStrategyConfigurationYamlSwapper;

public final class TrafficRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlTrafficRuleConfiguration, TrafficRuleConfiguration> {
    private final TrafficStrategyConfigurationYamlSwapper strategySwapper = new TrafficStrategyConfigurationYamlSwapper();
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();

    public YamlTrafficRuleConfiguration swapToYamlConfiguration(TrafficRuleConfiguration data) {
        YamlTrafficRuleConfiguration result = new YamlTrafficRuleConfiguration();
        data.getTrafficStrategies().forEach(each -> result.getTrafficStrategies().put(each.getName(), this.strategySwapper.swapToYamlConfiguration((TrafficStrategyConfiguration)each)));
        this.setYamlAlgorithms(data, result);
        return result;
    }

    private void setYamlAlgorithms(TrafficRuleConfiguration data, YamlTrafficRuleConfiguration yamlConfig) {
        if (null != data.getTrafficAlgorithms()) {
            data.getTrafficAlgorithms().forEach((key, value) -> yamlConfig.getTrafficAlgorithms().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
        if (null != data.getLoadBalancers()) {
            data.getLoadBalancers().forEach((key, value) -> yamlConfig.getLoadBalancers().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
    }

    public TrafficRuleConfiguration swapToObject(YamlTrafficRuleConfiguration yamlConfig) {
        TrafficRuleConfiguration result = new TrafficRuleConfiguration();
        for (Map.Entry<String, YamlTrafficStrategyConfiguration> entry : yamlConfig.getTrafficStrategies().entrySet()) {
            YamlTrafficStrategyConfiguration strategyConfig = entry.getValue();
            strategyConfig.setName(entry.getKey());
            result.getTrafficStrategies().add(this.strategySwapper.swapToObject(strategyConfig));
        }
        this.setAlgorithms(yamlConfig, result);
        return result;
    }

    private void setAlgorithms(YamlTrafficRuleConfiguration yamlConfig, TrafficRuleConfiguration ruleConfig) {
        if (null != yamlConfig.getTrafficAlgorithms()) {
            yamlConfig.getTrafficAlgorithms().forEach((key, value) -> ruleConfig.getTrafficAlgorithms().put(key, this.algorithmSwapper.swapToObject(value)));
        }
        if (null != yamlConfig.getLoadBalancers()) {
            yamlConfig.getLoadBalancers().forEach((key, value) -> ruleConfig.getLoadBalancers().put(key, this.algorithmSwapper.swapToObject(value)));
        }
    }

    public Class<TrafficRuleConfiguration> getTypeClass() {
        return TrafficRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "TRAFFIC";
    }

    public int getOrder() {
        return 800;
    }
}

