/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.hint.SQLHintProperties;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.api.traffic.hint.HintTrafficAlgorithm;
import org.apache.shardingsphere.traffic.api.traffic.hint.HintTrafficValue;
import org.apache.shardingsphere.traffic.api.traffic.identifier.SimplifiedTrafficAlgorithm;
import org.apache.shardingsphere.traffic.api.traffic.segment.SegmentTrafficAlgorithm;
import org.apache.shardingsphere.traffic.api.traffic.segment.SegmentTrafficValue;
import org.apache.shardingsphere.traffic.api.traffic.transaction.TransactionTrafficAlgorithm;
import org.apache.shardingsphere.traffic.api.traffic.transaction.TransactionTrafficValue;
import org.apache.shardingsphere.traffic.factory.TrafficAlgorithmFactory;
import org.apache.shardingsphere.traffic.factory.TrafficLoadBalanceAlgorithmFactory;
import org.apache.shardingsphere.traffic.rule.TrafficStrategyRule;
import org.apache.shardingsphere.traffic.spi.TrafficAlgorithm;
import org.apache.shardingsphere.traffic.spi.TrafficLoadBalanceAlgorithm;

public final class TrafficRule
implements GlobalRule {
    private final Collection<TrafficStrategyRule> strategyRules;

    public TrafficRule(TrafficRuleConfiguration config) {
        Map<String, TrafficAlgorithm> trafficAlgorithms = this.createTrafficAlgorithms(config.getTrafficAlgorithms());
        Map<String, TrafficLoadBalanceAlgorithm> loadBalancers = this.createTrafficLoadBalanceAlgorithms(config.getLoadBalancers());
        this.strategyRules = this.createTrafficStrategyRules(config.getTrafficStrategies(), trafficAlgorithms, loadBalancers);
    }

    private Map<String, TrafficAlgorithm> createTrafficAlgorithms(Map<String, ShardingSphereAlgorithmConfiguration> trafficAlgorithms) {
        LinkedHashMap<String, TrafficAlgorithm> result = new LinkedHashMap<String, TrafficAlgorithm>();
        for (Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry : trafficAlgorithms.entrySet()) {
            result.put(entry.getKey(), TrafficAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)entry.getValue()));
        }
        return result;
    }

    private Map<String, TrafficLoadBalanceAlgorithm> createTrafficLoadBalanceAlgorithms(Map<String, ShardingSphereAlgorithmConfiguration> loadBalancers) {
        LinkedHashMap<String, TrafficLoadBalanceAlgorithm> result = new LinkedHashMap<String, TrafficLoadBalanceAlgorithm>();
        for (Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry : loadBalancers.entrySet()) {
            result.put(entry.getKey(), TrafficLoadBalanceAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)entry.getValue()));
        }
        return result;
    }

    private Collection<TrafficStrategyRule> createTrafficStrategyRules(Collection<TrafficStrategyConfiguration> trafficStrategies, Map<String, TrafficAlgorithm> trafficAlgorithms, Map<String, TrafficLoadBalanceAlgorithm> loadBalancers) {
        LinkedList<TrafficStrategyRule> noneTransactionStrategyRules = new LinkedList<TrafficStrategyRule>();
        LinkedList<TrafficStrategyRule> result = new LinkedList<TrafficStrategyRule>();
        for (TrafficStrategyConfiguration each : trafficStrategies) {
            TrafficAlgorithm trafficAlgorithm = this.getTrafficAlgorithm(trafficAlgorithms, each.getAlgorithmName());
            TrafficStrategyRule trafficStrategyRule = this.createTrafficStrategyRule(each, trafficAlgorithm, loadBalancers);
            if (this.isTransactionStrategyRule(trafficAlgorithm)) {
                result.add(trafficStrategyRule);
                continue;
            }
            noneTransactionStrategyRules.add(trafficStrategyRule);
        }
        result.addAll(noneTransactionStrategyRules);
        return result;
    }

    private TrafficStrategyRule createTrafficStrategyRule(TrafficStrategyConfiguration strategyConfig, TrafficAlgorithm trafficAlgorithm, Map<String, TrafficLoadBalanceAlgorithm> loadBalancers) {
        TrafficStrategyRule result;
        if (trafficAlgorithm instanceof SimplifiedTrafficAlgorithm) {
            result = new TrafficStrategyRule(strategyConfig.getName(), Collections.emptyList(), trafficAlgorithm, null);
        } else {
            TrafficLoadBalanceAlgorithm loadBalancer = this.getLoadBalancer(loadBalancers, strategyConfig.getLoadBalancerName());
            result = new TrafficStrategyRule(strategyConfig.getName(), new LinkedHashSet<String>(strategyConfig.getLabels()), trafficAlgorithm, loadBalancer);
        }
        return result;
    }

    private boolean isTransactionStrategyRule(TrafficAlgorithm trafficAlgorithm) {
        return trafficAlgorithm instanceof TransactionTrafficAlgorithm;
    }

    public Optional<TrafficStrategyRule> findMatchedStrategyRule(LogicSQL logicSQL, boolean inTransaction) {
        for (TrafficStrategyRule each : this.strategyRules) {
            if (!this.match(each.getTrafficAlgorithm(), logicSQL, inTransaction)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private TrafficAlgorithm getTrafficAlgorithm(Map<String, TrafficAlgorithm> trafficAlgorithms, String algorithmName) {
        TrafficAlgorithm result = trafficAlgorithms.get(algorithmName);
        Preconditions.checkState((null != result ? 1 : 0) != 0, (Object)"Traffic algorithm can not be null.");
        return result;
    }

    private boolean match(TrafficAlgorithm trafficAlgorithm, LogicSQL logicSQL, boolean inTransaction) {
        if (trafficAlgorithm instanceof TransactionTrafficAlgorithm) {
            return this.matchTransactionTraffic((TransactionTrafficAlgorithm)trafficAlgorithm, inTransaction);
        }
        if (trafficAlgorithm instanceof HintTrafficAlgorithm) {
            SQLHintProperties sqlHintProps = logicSQL.getSqlStatementContext() instanceof CommonSQLStatementContext ? ((CommonSQLStatementContext)logicSQL.getSqlStatementContext()).getSqlHintExtractor().getSqlHintProperties() : new SQLHintProperties(new Properties());
            return this.matchHintTraffic((HintTrafficAlgorithm)trafficAlgorithm, sqlHintProps);
        }
        if (trafficAlgorithm instanceof SegmentTrafficAlgorithm) {
            SQLStatement sqlStatement = logicSQL.getSqlStatementContext().getSqlStatement();
            return this.matchSegmentTraffic((SegmentTrafficAlgorithm)trafficAlgorithm, logicSQL.getSql(), sqlStatement);
        }
        return false;
    }

    private boolean matchHintTraffic(HintTrafficAlgorithm trafficAlgorithm, SQLHintProperties sqlHintProps) {
        HintTrafficValue hintTrafficValue = new HintTrafficValue(sqlHintProps);
        return trafficAlgorithm.match(hintTrafficValue);
    }

    private boolean matchSegmentTraffic(SegmentTrafficAlgorithm trafficAlgorithm, String sql, SQLStatement sqlStatement) {
        SegmentTrafficValue segmentTrafficValue = new SegmentTrafficValue(sqlStatement, sql);
        return trafficAlgorithm.match(segmentTrafficValue);
    }

    private boolean matchTransactionTraffic(TransactionTrafficAlgorithm trafficAlgorithm, boolean inTransaction) {
        TransactionTrafficValue transactionTrafficValue = new TransactionTrafficValue(inTransaction);
        return trafficAlgorithm.match(transactionTrafficValue);
    }

    private TrafficLoadBalanceAlgorithm getLoadBalancer(Map<String, TrafficLoadBalanceAlgorithm> loadBalancers, String loadBalancerName) {
        TrafficLoadBalanceAlgorithm result = loadBalancers.get(loadBalancerName);
        Preconditions.checkState((null != result ? 1 : 0) != 0, (Object)"Traffic load balance algorithm can not be null.");
        return result;
    }

    public Collection<String> getLabels() {
        HashSet<String> result = new HashSet<String>();
        for (TrafficStrategyRule each : this.strategyRules) {
            result.addAll(each.getLabels());
        }
        return result;
    }

    public String getType() {
        return TrafficRule.class.getSimpleName();
    }

    @Generated
    public Collection<TrafficStrategyRule> getStrategyRules() {
        return this.strategyRules;
    }
}

