/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.algorithm.traffic.segment;

import com.google.common.base.Preconditions;
import java.util.Properties;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.traffic.api.traffic.segment.SegmentTrafficAlgorithm;
import org.apache.shardingsphere.traffic.api.traffic.segment.SegmentTrafficValue;

public final class SQLRegexTrafficAlgorithm
implements SegmentTrafficAlgorithm {
    private static final String REGEX_PROPS_KEY = "regex";
    private Properties props;
    private Pattern regex;

    public void init(Properties props) {
        this.props = props;
        Preconditions.checkArgument((boolean)props.containsKey(REGEX_PROPS_KEY), (String)"%s can not be null.", (Object)REGEX_PROPS_KEY);
        this.regex = Pattern.compile(props.getProperty(REGEX_PROPS_KEY));
    }

    public boolean match(SegmentTrafficValue segmentTrafficValue) {
        return this.regex.matcher(segmentTrafficValue.getSql()).matches();
    }

    public String getType() {
        return "SQL_REGEX";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

