/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.algorithm.traffic.segment;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.traffic.api.traffic.segment.SegmentTrafficAlgorithm;
import org.apache.shardingsphere.traffic.api.traffic.segment.SegmentTrafficValue;

public final class SQLMatchTrafficAlgorithm
implements SegmentTrafficAlgorithm {
    private static final String SQL_PROPS_KEY = "sql";
    private static final String EXCLUDED_CHARACTERS = "[]`'\" ";
    private Properties props;
    private Collection<String> sql;

    public void init(Properties props) {
        this.props = props;
        Preconditions.checkArgument((boolean)props.containsKey(SQL_PROPS_KEY), (String)"%s cannot be null.", (Object)SQL_PROPS_KEY);
        this.sql = this.getExactlySQL(props.getProperty(SQL_PROPS_KEY));
    }

    private Collection<String> getExactlySQL(String value) {
        List values = Splitter.on((String)";").trimResults().omitEmptyStrings().splitToList((CharSequence)value);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String each : values) {
            result.add(CharMatcher.anyOf((CharSequence)EXCLUDED_CHARACTERS).removeFrom((CharSequence)each));
        }
        return result;
    }

    public boolean match(SegmentTrafficValue segmentTrafficValue) {
        return this.sql.contains(SQLUtil.trimSemicolon((String)CharMatcher.anyOf((CharSequence)EXCLUDED_CHARACTERS).removeFrom((CharSequence)segmentTrafficValue.getSql())));
    }

    public String getType() {
        return "SQL_MATCH";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

