/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.standalone.lock.StandaloneLockContext;
import org.apache.shardingsphere.mode.manager.standalone.workerid.generator.StandaloneWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepositoryFactory;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.TransactionContextsBuilder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;

public final class StandaloneContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)StandalonePersistRepositoryFactory.getInstance((PersistRepositoryConfiguration)parameter.getModeConfig().getRepository()));
        this.persistConfigurations(metaDataPersistService, parameter);
        MetaDataContexts metaDataContexts = this.createMetaDataContextsBuilder(metaDataPersistService, parameter).build(metaDataPersistService);
        return this.createContextManager(parameter, metaDataContexts);
    }

    private void persistConfigurations(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        if (!parameter.isEmpty()) {
            metaDataPersistService.persistConfigurations(parameter.getDatabaseConfigs(), parameter.getGlobalRuleConfigs(), parameter.getProps(), parameter.getModeConfig().isOverwrite());
        }
    }

    private MetaDataContextsBuilder createMetaDataContextsBuilder(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        Set<String> databaseNames = InstanceType.JDBC == parameter.getInstanceDefinition().getInstanceType() ? parameter.getDatabaseConfigs().keySet() : metaDataPersistService.getSchemaMetaDataService().loadAllDatabaseNames();
        Map<String, DatabaseConfiguration> databaseConfigMap = this.getDatabaseConfigMap(databaseNames, metaDataPersistService, parameter);
        Collection globalRuleConfigs = metaDataPersistService.getGlobalRuleService().load();
        ConfigurationProperties props = new ConfigurationProperties(metaDataPersistService.getPropsService().load());
        return new MetaDataContextsBuilder(databaseConfigMap, globalRuleConfigs, props);
    }

    private Map<String, DatabaseConfiguration> getDatabaseConfigMap(Collection<String> databaseNames, MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        HashMap<String, DatabaseConfiguration> result = new HashMap<String, DatabaseConfiguration>(databaseNames.size(), 1.0f);
        databaseNames.forEach(each -> result.put((String)each, this.createDatabaseConfiguration((String)each, metaDataPersistService, parameter)));
        return result;
    }

    private DatabaseConfiguration createDatabaseConfiguration(String databaseName, MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        Map dataSources = metaDataPersistService.getEffectiveDataSources(databaseName, parameter.getDatabaseConfigs());
        Collection databaseRuleConfigs = metaDataPersistService.getDatabaseRulePersistService().load(databaseName);
        return new DataSourceProvidedDatabaseConfiguration(dataSources, databaseRuleConfigs);
    }

    private ContextManager createContextManager(ContextManagerBuilderParameter parameter, MetaDataContexts metaDataContexts) {
        InstanceContext instanceContext = new InstanceContext(new ComputeNodeInstance(parameter.getInstanceDefinition()), (WorkerIdGenerator)new StandaloneWorkerIdGenerator(), parameter.getModeConfig(), (LockContext)new StandaloneLockContext());
        this.generateTransactionConfigurationFile(instanceContext, metaDataContexts);
        TransactionContexts transactionContexts = new TransactionContextsBuilder(metaDataContexts.getMetaData().getDatabases(), metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules()).build();
        ContextManager result = new ContextManager(metaDataContexts, transactionContexts, instanceContext);
        this.setInstanceContext(result);
        return result;
    }

    private void generateTransactionConfigurationFile(InstanceContext instanceContext, MetaDataContexts metaDataContexts) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        if (transactionRule.isPresent()) {
            Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.findInstance((String)transactionRule.get().getProviderType());
            fileGenerator.ifPresent(optional -> optional.generateFile(((TransactionRule)transactionRule.get()).getProps(), instanceContext));
        }
    }

    private void setInstanceContext(ContextManager contextManager) {
        contextManager.getMetaDataContexts().getMetaData().getDatabases().forEach((key, value) -> value.getRuleMetaData().getRules().stream().filter(each -> each instanceof InstanceAwareRule).forEach(each -> ((InstanceAwareRule)each).setInstanceContext(contextManager.getInstanceContext())));
    }

    public String getType() {
        return "Standalone";
    }
}

