/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.spi.annotation.SingletonSPI;

public final class ShardingSphereServiceLoader {
    private static final Map<Class<?>, Collection<Object>> SERVICES = new ConcurrentHashMap();

    public static void register(Class<?> serviceInterface) {
        if (!SERVICES.containsKey(serviceInterface)) {
            SERVICES.put(serviceInterface, ShardingSphereServiceLoader.load(serviceInterface));
        }
    }

    private static <T> Collection<Object> load(Class<T> serviceInterface) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (T each : ServiceLoader.load(serviceInterface)) {
            result.add(each);
        }
        return result;
    }

    public static <T> Collection<T> getServiceInstances(Class<T> serviceInterface) {
        return null == serviceInterface.getAnnotation(SingletonSPI.class) ? ShardingSphereServiceLoader.createNewServiceInstances(serviceInterface) : ShardingSphereServiceLoader.getSingletonServiceInstances(serviceInterface);
    }

    private static <T> Collection<T> createNewServiceInstances(Class<T> serviceInterface) {
        if (!SERVICES.containsKey(serviceInterface)) {
            return Collections.emptyList();
        }
        Collection<Object> services = SERVICES.get(serviceInterface);
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        for (Object each : services) {
            result.add(each.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        return result;
    }

    private static <T> Collection<T> getSingletonServiceInstances(Class<T> serviceInterface) {
        return SERVICES.getOrDefault(serviceInterface, Collections.emptyList());
    }

    @Generated
    private ShardingSphereServiceLoader() {
    }
}

