/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;
import org.apache.shardingsphere.singletable.datanode.SingleTableDataNodeLoader;

public final class SingleTableRule
implements SchemaRule,
DataNodeContainedRule,
TableContainedRule,
MutableDataNodeRule,
ExportableRule {
    private String defaultDataSource;
    private final Collection<String> dataSourceNames;
    private final Map<String, Collection<DataNode>> singleTableDataNodes;
    private final Map<String, String> tableNames;

    public SingleTableRule(SingleTableRuleConfiguration config, String databaseName, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules, ConfigurationProperties props) {
        Map<String, DataSource> aggregateDataSourceMap = this.getAggregateDataSourceMap(dataSourceMap, builtRules);
        this.dataSourceNames = aggregateDataSourceMap.keySet();
        this.singleTableDataNodes = SingleTableDataNodeLoader.load(databaseName, databaseType, aggregateDataSourceMap, this.getExcludedTables(builtRules), props);
        this.tableNames = this.singleTableDataNodes.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> ((DataNode)((Collection)entry.getValue()).iterator().next()).getTableName()));
        config.getDefaultDataSource().ifPresent(optional -> {
            this.defaultDataSource = optional;
        });
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        Map<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceMap);
        for (ShardingSphereRule each : builtRules) {
            if (!(each instanceof DataSourceContainedRule)) continue;
            result = this.getAggregateDataSourceMap(result, (DataSourceContainedRule)each);
        }
        return result;
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, DataSourceContainedRule builtRule) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry entry : builtRule.getDataSourceMapper().entrySet()) {
            for (String each : (Collection)entry.getValue()) {
                if (!dataSourceMap.containsKey(each)) continue;
                result.putIfAbsent((String)entry.getKey(), dataSourceMap.remove(each));
            }
        }
        result.putAll(dataSourceMap);
        return result;
    }

    public boolean isSingleTablesInSameDataSource(Collection<QualifiedTable> singleTableNames) {
        String firstFoundDataSourceName = null;
        for (QualifiedTable each : singleTableNames) {
            Optional<DataNode> dataNode = this.findSingleTableDataNode(each.getSchemaName(), each.getTableName());
            if (!dataNode.isPresent()) continue;
            if (null == firstFoundDataSourceName) {
                firstFoundDataSourceName = dataNode.get().getDataSourceName();
                continue;
            }
            if (firstFoundDataSourceName.equals(dataNode.get().getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    public boolean isAllTablesInSameDataSource(RouteContext routeContext, Collection<QualifiedTable> singleTableNames) {
        if (!this.isSingleTablesInSameDataSource(singleTableNames)) {
            return false;
        }
        QualifiedTable sampleTable = singleTableNames.iterator().next();
        Optional<DataNode> dataNode = this.findSingleTableDataNode(sampleTable.getSchemaName(), sampleTable.getTableName());
        if (dataNode.isPresent()) {
            for (RouteUnit each : routeContext.getRouteUnits()) {
                if (each.getDataSourceMapper().getLogicName().equals(dataNode.get().getDataSourceName())) continue;
                return false;
            }
        }
        return true;
    }

    public Optional<String> getDefaultDataSource() {
        return Optional.ofNullable(this.defaultDataSource);
    }

    public Collection<QualifiedTable> getSingleTableNames(Collection<QualifiedTable> qualifiedTables) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        for (QualifiedTable each : qualifiedTables) {
            Collection dataNodes = this.singleTableDataNodes.getOrDefault(each.getTableName().toLowerCase(), new LinkedList());
            if (dataNodes.isEmpty() || !this.containsDataNode(each, dataNodes)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean containsDataNode(QualifiedTable qualifiedTable, Collection<DataNode> dataNodes) {
        for (DataNode each : dataNodes) {
            if (!qualifiedTable.getSchemaName().equalsIgnoreCase(each.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    public void put(String dataSourceName, String schemaName, String tableName) {
        if (this.dataSourceNames.contains(dataSourceName)) {
            Collection dataNodes = this.singleTableDataNodes.computeIfAbsent(tableName.toLowerCase(), key -> new LinkedHashSet());
            DataNode dataNode = new DataNode(dataSourceName, tableName);
            dataNode.setSchemaName(schemaName);
            dataNodes.add(dataNode);
            this.tableNames.put(tableName.toLowerCase(), tableName);
        }
    }

    public void remove(String schemaName, String tableName) {
        this.remove(Collections.singleton(schemaName.toLowerCase()), tableName);
    }

    public void remove(Collection<String> schemaNames, String tableName) {
        if (!this.singleTableDataNodes.containsKey(tableName.toLowerCase())) {
            return;
        }
        Collection<DataNode> dataNodes = this.singleTableDataNodes.get(tableName.toLowerCase());
        dataNodes.removeIf(each -> schemaNames.contains(each.getSchemaName().toLowerCase()));
        if (dataNodes.isEmpty()) {
            this.singleTableDataNodes.remove(tableName.toLowerCase());
            this.tableNames.remove(tableName.toLowerCase());
        }
    }

    public Optional<DataNode> findSingleTableDataNode(String schemaName, String tableName) {
        Collection dataNodes = this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), new LinkedHashSet());
        for (DataNode each : dataNodes) {
            if (!schemaName.equalsIgnoreCase(each.getSchemaName())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Collection<String> getExcludedTables(Collection<ShardingSphereRule> rules) {
        return rules.stream().filter(each -> each instanceof DataNodeContainedRule).flatMap(each -> ((DataNodeContainedRule)each).getAllTables().stream()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.singleTableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), Collections.emptyList());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return Optional.empty();
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return false;
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return Optional.empty();
    }

    public Collection<String> getAllTables() {
        return new HashSet<String>(this.tableNames.values());
    }

    public Collection<String> getTables() {
        return new HashSet<String>(this.tableNames.values());
    }

    public String getType() {
        return SingleTableRule.class.getSimpleName();
    }

    public Map<String, Supplier<Object>> getExportedMethods() {
        return Collections.singletonMap("single_tables", this.tableNames::keySet);
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, Collection<DataNode>> getSingleTableDataNodes() {
        return this.singleTableDataNodes;
    }

    @Generated
    public Map<String, String> getTableNames() {
        return this.tableNames;
    }
}

