/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.route;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.singletable.route.engine.SingleTableRouteEngineFactory;
import org.apache.shardingsphere.singletable.route.validator.SingleTableMetadataValidator;
import org.apache.shardingsphere.singletable.route.validator.SingleTableMetadataValidatorFactory;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class SingleTableSQLRouter
implements SQLRouter<SingleTableRule> {
    public RouteContext createRouteContext(LogicSQL logicSQL, ShardingSphereDatabase database, SingleTableRule rule, ConfigurationProperties props) {
        if (1 == database.getResource().getDataSources().size()) {
            return this.createSingleDataSourceRouteContext(rule, database);
        }
        RouteContext result = new RouteContext();
        SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
        Optional<SingleTableMetadataValidator> validator = SingleTableMetadataValidatorFactory.newInstance(sqlStatementContext.getSqlStatement());
        validator.ifPresent(optional -> optional.validate(rule, sqlStatementContext, database));
        Collection<QualifiedTable> singleTableNames = SingleTableSQLRouter.getSingleTableNames(sqlStatementContext, database, rule, result);
        if (!singleTableNames.isEmpty()) {
            SingleTableSQLRouter.validateSameDataSource(sqlStatementContext, rule, props, singleTableNames, result);
        }
        SingleTableRouteEngineFactory.newInstance(singleTableNames, sqlStatementContext.getSqlStatement()).ifPresent(optional -> optional.route(result, rule));
        return result;
    }

    public void decorateRouteContext(RouteContext routeContext, LogicSQL logicSQL, ShardingSphereDatabase database, SingleTableRule rule, ConfigurationProperties props) {
        SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
        Collection<QualifiedTable> singleTableNames = SingleTableSQLRouter.getSingleTableNames(sqlStatementContext, database, rule, routeContext);
        if (singleTableNames.isEmpty()) {
            return;
        }
        SingleTableSQLRouter.validateSameDataSource(sqlStatementContext, rule, props, singleTableNames, routeContext);
        SingleTableRouteEngineFactory.newInstance(singleTableNames, sqlStatementContext.getSqlStatement()).ifPresent(optional -> optional.route(routeContext, rule));
    }

    private RouteContext createSingleDataSourceRouteContext(SingleTableRule rule, ShardingSphereDatabase database) {
        String logicDataSource = rule.getDataSourceNames().iterator().next();
        String actualDataSource = (String)database.getResource().getDataSources().keySet().iterator().next();
        RouteContext result = new RouteContext();
        result.getRouteUnits().add(new RouteUnit(new RouteMapper(logicDataSource, actualDataSource), Collections.emptyList()));
        return result;
    }

    private static Collection<QualifiedTable> getSingleTableNames(SQLStatementContext<?> sqlStatementContext, ShardingSphereDatabase database, SingleTableRule rule, RouteContext routeContext) {
        DatabaseType databaseType = sqlStatementContext.getDatabaseType();
        Collection result = SingleTableSQLRouter.getQualifiedTables(database, databaseType, sqlStatementContext.getTablesContext().getTables());
        if (result.isEmpty() && sqlStatementContext instanceof IndexAvailable) {
            result = IndexMetaDataUtil.getTableNames((ShardingSphereDatabase)database, (DatabaseType)databaseType, (Collection)((IndexAvailable)sqlStatementContext).getIndexes());
        }
        return routeContext.getRouteUnits().isEmpty() && sqlStatementContext.getSqlStatement() instanceof CreateTableStatement ? result : rule.getSingleTableNames(result);
    }

    private static Collection<QualifiedTable> getQualifiedTables(ShardingSphereDatabase database, DatabaseType databaseType, Collection<SimpleTableSegment> tableSegments) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        String schemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)database.getName());
        for (SimpleTableSegment each : tableSegments) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(schemaName);
            result.add(new QualifiedTable(actualSchemaName, each.getTableName().getIdentifier().getValue()));
        }
        return result;
    }

    private static void validateSameDataSource(SQLStatementContext<?> sqlStatementContext, SingleTableRule rule, ConfigurationProperties props, Collection<QualifiedTable> singleTableNames, RouteContext routeContext) {
        boolean sqlFederationEnabled = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_FEDERATION_ENABLED);
        boolean allTablesInSameDataSource = sqlFederationEnabled ? sqlStatementContext instanceof SelectStatementContext || rule.isSingleTablesInSameDataSource(singleTableNames) : rule.isAllTablesInSameDataSource(routeContext, singleTableNames);
        Preconditions.checkState((boolean)allTablesInSameDataSource, (Object)"All tables must be in the same datasource.");
    }

    public int getOrder() {
        return 0;
    }

    public Class<SingleTableRule> getTypeClass() {
        return SingleTableRule.class;
    }
}

