/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.datanode;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.common.SchemaTableNamesLoader;

public final class SingleTableDataNodeLoader {
    public static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<String> excludedTables, ConfigurationProperties props) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>();
        boolean checkDuplicateTable = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.CHECK_DUPLICATE_TABLE_ENABLED);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, Collection<DataNode>> dataNodeMap = SingleTableDataNodeLoader.load(databaseName, databaseType, entry.getKey(), entry.getValue(), excludedTables);
            for (String each : dataNodeMap.keySet()) {
                Collection<DataNode> addedDataNodes = dataNodeMap.get(each);
                Collection existDataNodes = result.getOrDefault(each.toLowerCase(), new LinkedHashSet(addedDataNodes.size(), 1.0f));
                existDataNodes.addAll(addedDataNodes);
                result.putIfAbsent(each.toLowerCase(), existDataNodes);
                if (!checkDuplicateTable) continue;
                Preconditions.checkState((!SingleTableDataNodeLoader.containsDuplicateTable(existDataNodes) ? 1 : 0) != 0, (String)"Single table conflict, there are multiple tables `%s` existed.", (Object)each);
            }
        }
        return result;
    }

    private static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType databaseType, String dataSourceName, DataSource dataSource, Collection<String> excludedTables) {
        Map<String, Collection<String>> schemaTableNames = SingleTableDataNodeLoader.loadSchemaTableNames(databaseName, databaseType, dataSource, dataSourceName);
        LinkedHashMap<String, Collection<DataNode>> result = new LinkedHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, Collection<String>> entry : schemaTableNames.entrySet()) {
            for (String each : entry.getValue()) {
                if (excludedTables.contains(each)) continue;
                Collection dataNodes = result.getOrDefault(each, new LinkedList());
                DataNode dataNode = new DataNode(dataSourceName, each);
                dataNode.setSchemaName(entry.getKey());
                dataNodes.add(dataNode);
                result.putIfAbsent(each, dataNodes);
            }
        }
        return result;
    }

    private static boolean containsDuplicateTable(Collection<DataNode> dataNodes) {
        HashSet<String> schemas = new HashSet<String>(dataNodes.size(), 1.0f);
        for (DataNode each : dataNodes) {
            if (schemas.add(each.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType databaseType, DataSource dataSource, String dataSourceName) {
        try {
            return SchemaTableNamesLoader.loadSchemaTableNames((String)databaseName, (DatabaseType)databaseType, (DataSource)dataSource);
        }
        catch (SQLException ex) {
            throw new ShardingSphereConfigurationException(String.format("Can not load table, databaseName: %s, dataSourceName: %s", databaseName, dataSourceName), (Throwable)ex);
        }
    }

    @Generated
    private SingleTableDataNodeLoader() {
    }
}

