/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowScalingJobStatusQueryResultSet
implements DistSQLResultSet {
    private static final RuleAlteredJobAPI RULE_ALTERED_JOB_API = RuleAlteredJobAPIFactory.getInstance();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        long currentTimeMillis = System.currentTimeMillis();
        this.data = RULE_ALTERED_JOB_API.getProgress(((ShowScalingStatusStatement)sqlStatement).getJobId()).entrySet().stream().map(entry -> {
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(entry.getKey());
            if (null != entry.getValue()) {
                result.add(((JobProgress)entry.getValue()).getDataSource());
                result.add(((JobProgress)entry.getValue()).getStatus());
                result.add(((JobProgress)entry.getValue()).isActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                result.add(((JobProgress)entry.getValue()).getInventoryFinishedPercentage());
                long latestActiveTimeMillis = ((JobProgress)entry.getValue()).getIncrementalLatestActiveTimeMillis();
                result.add(latestActiveTimeMillis > 0L ? TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis - latestActiveTimeMillis) : 0L);
            } else {
                result.add("");
                result.add("");
                result.add("");
                result.add("");
                result.add("");
            }
            return result;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("item", "data_source", "status", "active", "inventory_finished_percentage", "incremental_idle_seconds");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowScalingStatusStatement.class.getName();
    }
}

