/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPIFactory;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingCheckAlgorithmsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowScalingCheckAlgorithmsQueryResultSet
implements DistSQLResultSet {
    private static final RuleAlteredJobAPI RULE_ALTERED_JOB_API = RuleAlteredJobAPIFactory.getInstance();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        this.data = RULE_ALTERED_JOB_API.listDataConsistencyCheckAlgorithms().stream().map(each -> Arrays.asList(each.getType(), String.join((CharSequence)",", each.getSupportedDatabaseTypes()), each.getDescription())).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "supported_database_types", "description");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowScalingCheckAlgorithmsStatement.class.getName();
    }
}

