/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.yaml.swapper.rule;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.KeyGenerateStrategyConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.ShardingStrategyConfigurationYamlSwapper;

public final class ShardingTableRuleConfigurationYamlSwapper
implements YamlConfigurationSwapper<YamlTableRuleConfiguration, ShardingTableRuleConfiguration> {
    private final ShardingStrategyConfigurationYamlSwapper shardingStrategyYamlSwapper = new ShardingStrategyConfigurationYamlSwapper();
    private final KeyGenerateStrategyConfigurationYamlSwapper keyGenerateStrategyYamlSwapper = new KeyGenerateStrategyConfigurationYamlSwapper();

    public YamlTableRuleConfiguration swapToYamlConfiguration(ShardingTableRuleConfiguration data) {
        YamlTableRuleConfiguration result = new YamlTableRuleConfiguration();
        result.setLogicTable(data.getLogicTable());
        result.setActualDataNodes(data.getActualDataNodes());
        result.setReplaceTablePrefix(data.getReplaceTablePrefix());
        if (null != data.getDatabaseShardingStrategy()) {
            result.setDatabaseStrategy(this.shardingStrategyYamlSwapper.swapToYamlConfiguration(data.getDatabaseShardingStrategy()));
        }
        if (null != data.getTableShardingStrategy()) {
            result.setTableStrategy(this.shardingStrategyYamlSwapper.swapToYamlConfiguration(data.getTableShardingStrategy()));
        }
        if (null != data.getKeyGenerateStrategy()) {
            result.setKeyGenerateStrategy(this.keyGenerateStrategyYamlSwapper.swapToYamlConfiguration(data.getKeyGenerateStrategy()));
        }
        return result;
    }

    public ShardingTableRuleConfiguration swapToObject(YamlTableRuleConfiguration yamlConfig) {
        Preconditions.checkNotNull((Object)yamlConfig.getLogicTable(), (Object)"Logic table cannot be null.");
        ShardingTableRuleConfiguration result = new ShardingTableRuleConfiguration(yamlConfig.getLogicTable(), yamlConfig.getActualDataNodes());
        result.setReplaceTablePrefix(yamlConfig.getReplaceTablePrefix());
        if (null != yamlConfig.getDatabaseStrategy()) {
            result.setDatabaseShardingStrategy(this.shardingStrategyYamlSwapper.swapToObject(yamlConfig.getDatabaseStrategy()));
        }
        if (null != yamlConfig.getTableStrategy()) {
            result.setTableShardingStrategy(this.shardingStrategyYamlSwapper.swapToObject(yamlConfig.getTableStrategy()));
        }
        if (null != yamlConfig.getKeyGenerateStrategy()) {
            result.setKeyGenerateStrategy(this.keyGenerateStrategyYamlSwapper.swapToObject(yamlConfig.getKeyGenerateStrategy()));
        }
        return result;
    }
}

