/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.InstanceAwareAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.expr.InlineExpressionParser;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.CheckableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.distsql.handler.checker.BindingTableCheckedConfig;
import org.apache.shardingsphere.sharding.factory.KeyGenerateAlgorithmFactory;
import org.apache.shardingsphere.sharding.factory.ShardingAlgorithmFactory;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtil;

public final class ShardingRule
implements SchemaRule,
DataNodeContainedRule,
TableContainedRule,
InstanceAwareRule,
CheckableRule {
    private static final String EQUAL = "=";
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private final Collection<String> dataSourceNames;
    private final Map<String, ShardingAlgorithm> shardingAlgorithms = new LinkedHashMap<String, ShardingAlgorithm>();
    private final Map<String, KeyGenerateAlgorithm> keyGenerators = new LinkedHashMap<String, KeyGenerateAlgorithm>();
    private final Map<String, TableRule> tableRules = new LinkedHashMap<String, TableRule>();
    private final Map<String, BindingTableRule> bindingTableRules = new LinkedHashMap<String, BindingTableRule>();
    private final Collection<String> broadcastTables;
    private final ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration defaultTableShardingStrategyConfig;
    private final KeyGenerateAlgorithm defaultKeyGenerateAlgorithm;
    private final String defaultShardingColumn;
    private final Map<String, Collection<DataNode>> shardingTableDataNodes;

    public ShardingRule(ShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        this.shardingAlgorithms.putAll(this.createShardingAlgorithms(config.getShardingAlgorithms(), config.getTables(), config.getAutoTables()));
        config.getKeyGenerators().forEach((key, value) -> this.keyGenerators.put((String)key, KeyGenerateAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)value)));
        this.tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.bindingTableRules.putAll(this.createBindingTableRules(config.getBindingTableGroups(), config.getTables(), config.getAutoTables(), this.tableRules));
        this.broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? KeyGenerateAlgorithmFactory.newInstance() : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = config.getDefaultShardingColumn();
        this.shardingTableDataNodes = this.createShardingTableDataNodes(this.tableRules);
        Preconditions.checkArgument((boolean)this.isValidBindingTableConfiguration(this.bindingTableRules, new BindingTableCheckedConfig(this.dataSourceNames, this.shardingAlgorithms, this.broadcastTables, this.defaultDatabaseShardingStrategyConfig, this.defaultTableShardingStrategyConfig, this.defaultShardingColumn)), (Object)"Invalid binding table configuration in ShardingRuleConfiguration.");
    }

    public ShardingRule(AlgorithmProvidedShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        this.shardingAlgorithms.putAll(config.getShardingAlgorithms());
        this.keyGenerators.putAll(config.getKeyGenerators());
        this.tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.bindingTableRules.putAll(this.createBindingTableRules(config.getBindingTableGroups(), config.getTables(), config.getAutoTables(), this.tableRules));
        this.broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? KeyGenerateAlgorithmFactory.newInstance() : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = config.getDefaultShardingColumn();
        this.shardingTableDataNodes = this.createShardingTableDataNodes(this.tableRules);
        Preconditions.checkArgument((boolean)this.isValidBindingTableConfiguration(this.bindingTableRules, new BindingTableCheckedConfig(this.dataSourceNames, this.shardingAlgorithms, this.broadcastTables, this.defaultDatabaseShardingStrategyConfig, this.defaultTableShardingStrategyConfig, this.defaultShardingColumn)), (Object)"Invalid binding table configuration in ShardingRuleConfiguration.");
    }

    public boolean check(RuleConfiguration ruleConfig, Collection<String> dataSourceNames) {
        if (!(ruleConfig instanceof ShardingRuleConfiguration)) {
            return true;
        }
        ShardingRuleConfiguration config = (ShardingRuleConfiguration)ruleConfig;
        Collection<String> allDataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        HashMap<String, ShardingAlgorithm> shardingAlgorithms = new HashMap<String, ShardingAlgorithm>(config.getShardingAlgorithms().size(), 1.0f);
        HashMap<String, TableRule> tableRules = new HashMap<String, TableRule>();
        config.getShardingAlgorithms().forEach((key, value) -> shardingAlgorithms.put((String)key, ShardingAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)value)));
        tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy(), allDataSourceNames));
        tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), shardingAlgorithms, config.getDefaultKeyGenerateStrategy(), allDataSourceNames));
        Map<String, BindingTableRule> bindingTableRules = this.createBindingTableRules(config.getBindingTableGroups(), config.getTables(), config.getAutoTables(), tableRules);
        Collection<String> broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        NoneShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        NoneShardingStrategyConfiguration defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        return this.isValidBindingTableConfiguration(bindingTableRules, new BindingTableCheckedConfig(allDataSourceNames, shardingAlgorithms, broadcastTables, (ShardingStrategyConfiguration)defaultDatabaseShardingStrategyConfig, (ShardingStrategyConfiguration)defaultTableShardingStrategyConfig, config.getDefaultShardingColumn()));
    }

    private Map<String, Collection<DataNode>> createShardingTableDataNodes(Map<String, TableRule> tableRules) {
        HashMap<String, Collection<DataNode>> result = new HashMap<String, Collection<DataNode>>(tableRules.size(), 1.0f);
        for (TableRule each : tableRules.values()) {
            result.put(each.getLogicTable().toLowerCase(), each.getActualDataNodes());
        }
        return result;
    }

    private Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty() && autoTableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        autoTableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingAutoTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        List actualDataSources = new InlineExpressionParser(shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return new HashSet<String>(actualDataSources);
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List actualDataNodes = new InlineExpressionParser(shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private Map<String, TableRule> createTableRules(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return tableRuleConfigs.stream().map(each -> new TableRule((ShardingTableRuleConfiguration)each, this.dataSourceNames, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, TableRule> createTableRules(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, Collection<String> dataSourceNames) {
        return tableRuleConfigs.stream().map(each -> new TableRule((ShardingTableRuleConfiguration)each, dataSourceNames, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, TableRule> createAutoTableRules(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return autoTableRuleConfigs.stream().map(each -> this.createAutoTableRule(defaultKeyGenerateStrategyConfig, (ShardingAutoTableRuleConfiguration)each)).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, TableRule> createAutoTableRules(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Map<String, ShardingAlgorithm> shardingAlgorithms, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, Collection<String> dataSourceNames) {
        return autoTableRuleConfigs.stream().map(each -> this.createAutoTableRule(defaultKeyGenerateStrategyConfig, (ShardingAutoTableRuleConfiguration)each, shardingAlgorithms, dataSourceNames)).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private TableRule createAutoTableRule(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig) {
        ShardingAlgorithm shardingAlgorithm = null == autoTableRuleConfig.getShardingStrategy() ? null : this.shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        Preconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), (Object)"Sharding auto table rule configuration must match sharding auto table algorithm.");
        return new TableRule(autoTableRuleConfig, this.dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private TableRule createAutoTableRule(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig, Map<String, ShardingAlgorithm> shardingAlgorithms, Collection<String> dataSourceNames) {
        ShardingAlgorithm shardingAlgorithm = null == autoTableRuleConfig.getShardingStrategy() ? null : shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        Preconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), (Object)"Sharding auto table rule configuration must match sharding auto table algorithm.");
        return new TableRule(autoTableRuleConfig, dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private Collection<String> createBroadcastTables(Collection<String> broadcastTables) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(broadcastTables);
        return result;
    }

    private Map<String, BindingTableRule> createBindingTableRules(Collection<String> bindingTableGroups, Collection<ShardingTableRuleConfiguration> tables, Collection<ShardingAutoTableRuleConfiguration> autoTables, Map<String, TableRule> tableRules) {
        Map<String, String> logicTableReplaceTablePrefixMap = this.getLogicTableReplaceTablePrefixMap(tables, autoTables);
        LinkedHashMap<String, BindingTableRule> result = new LinkedHashMap<String, BindingTableRule>();
        for (String each : bindingTableGroups) {
            BindingTableRule bindingTableRule = this.createBindingTableRule(each, tableRules, logicTableReplaceTablePrefixMap);
            for (String logicTable : bindingTableRule.getAllLogicTables()) {
                result.put(logicTable.toLowerCase(), bindingTableRule);
            }
        }
        return result;
    }

    private Map<String, String> getLogicTableReplaceTablePrefixMap(Collection<ShardingTableRuleConfiguration> tables, Collection<ShardingAutoTableRuleConfiguration> autoTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(tables.size() + autoTables.size(), 1.0f);
        for (ShardingTableRuleConfiguration shardingTableRuleConfiguration : tables) {
            if (null == shardingTableRuleConfiguration.getReplaceTablePrefix()) continue;
            result.put(shardingTableRuleConfiguration.getLogicTable(), shardingTableRuleConfiguration.getReplaceTablePrefix());
        }
        for (ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfiguration : autoTables) {
            if (null == shardingAutoTableRuleConfiguration.getReplaceTablePrefix()) continue;
            result.put(shardingAutoTableRuleConfiguration.getLogicTable(), shardingAutoTableRuleConfiguration.getReplaceTablePrefix());
        }
        return result;
    }

    private BindingTableRule createBindingTableRule(String bindingTableGroup, Map<String, TableRule> tableRules, Map<String, String> logicTableReplaceTablePrefixMap) {
        BindingTableRule result = new BindingTableRule();
        for (String each : Splitter.on((String)",").trimResults().splitToList((CharSequence)bindingTableGroup)) {
            String replaceTablePrefix = logicTableReplaceTablePrefixMap.get(each);
            String logicTable = Strings.isNullOrEmpty((String)replaceTablePrefix) ? each : replaceTablePrefix + each;
            TableRule tableRule = Optional.ofNullable(tableRules.get(logicTable.toLowerCase())).orElseThrow(() -> new ShardingSphereConfigurationException("Cannot find table rule with logic table: '%s'", new Object[]{logicTable}));
            result.getTableRules().put(tableRule.getLogicTable().toLowerCase(), tableRule);
        }
        return result;
    }

    private boolean isValidBindingTableConfiguration(Map<String, BindingTableRule> bindingTableRules, BindingTableCheckedConfig checkedConfig) {
        for (BindingTableRule each : new HashSet<BindingTableRule>(bindingTableRules.values())) {
            Collection<TableRule> bindingTables = each.getTableRules().values();
            if (bindingTables.size() <= 1) continue;
            Iterator<TableRule> iterator = bindingTables.iterator();
            TableRule sampleTableRule = iterator.next();
            while (iterator.hasNext()) {
                TableRule tableRule = iterator.next();
                if (!this.isValidActualDatasourceName(sampleTableRule, tableRule) || !this.isValidActualTableName(sampleTableRule, tableRule)) {
                    return false;
                }
                if (this.isValidShardingAlgorithm(sampleTableRule, tableRule, true, checkedConfig) && this.isValidShardingAlgorithm(sampleTableRule, tableRule, false, checkedConfig)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidActualDatasourceName(TableRule sampleTableRule, TableRule tableRule) {
        return sampleTableRule.getActualDatasourceNames().equals(tableRule.getActualDatasourceNames());
    }

    private boolean isValidActualTableName(TableRule sampleTableRule, TableRule tableRule) {
        for (String each : sampleTableRule.getActualDatasourceNames()) {
            Collection actualTableNames;
            Collection sampleActualTableNames = sampleTableRule.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(sampleTableRule.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet());
            if (sampleActualTableNames.equals(actualTableNames = (Collection)tableRule.getActualTableNames(each).stream().map(optional -> optional.replace(tableRule.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet()))) continue;
            return false;
        }
        return true;
    }

    private boolean isValidShardingAlgorithm(TableRule sampleTableRule, TableRule tableRule, boolean databaseAlgorithm, BindingTableCheckedConfig checkedConfig) {
        String sampleAlgorithmExpression = this.getAlgorithmExpression(sampleTableRule, databaseAlgorithm, checkedConfig);
        String algorithmExpression = this.getAlgorithmExpression(tableRule, databaseAlgorithm, checkedConfig);
        return sampleAlgorithmExpression.equalsIgnoreCase(algorithmExpression);
    }

    private String getAlgorithmExpression(TableRule tableRule, boolean databaseAlgorithm, BindingTableCheckedConfig checkedConfig) {
        ShardingStrategyConfiguration shardingStrategyConfig = databaseAlgorithm ? (null == tableRule.getDatabaseShardingStrategyConfig() ? checkedConfig.getDefaultDatabaseShardingStrategyConfig() : tableRule.getDatabaseShardingStrategyConfig()) : (null == tableRule.getTableShardingStrategyConfig() ? checkedConfig.getDefaultTableShardingStrategyConfig() : tableRule.getTableShardingStrategyConfig());
        ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)checkedConfig.getShardingAlgorithms().get(shardingStrategyConfig.getShardingAlgorithmName());
        String originAlgorithmExpression = null == shardingAlgorithm ? "" : shardingAlgorithm.getProps().getProperty(ALGORITHM_EXPRESSION_KEY, "");
        String sampleDataNodePrefix = databaseAlgorithm ? tableRule.getDataSourceDataNode().getPrefix() : tableRule.getTableDataNode().getPrefix();
        String shardingColumn = this.getShardingColumn(shardingStrategyConfig, checkedConfig.getDefaultShardingColumn());
        return originAlgorithmExpression.replaceFirst(sampleDataNodePrefix, "").replaceFirst(shardingColumn, "").replaceAll(" ", "");
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String defaultShardingColumn) {
        String shardingColumn = defaultShardingColumn;
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            shardingColumn = ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            shardingColumn = ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        return null == shardingColumn ? "" : shardingColumn;
    }

    public Collection<String> getAllTables() {
        HashSet<String> result = new HashSet<String>(this.getTables());
        result.addAll(this.getAllActualTables());
        return result;
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategyConfig() ? this.defaultDatabaseShardingStrategyConfig : tableRule.getDatabaseShardingStrategyConfig();
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategyConfig() ? this.defaultTableShardingStrategyConfig : tableRule.getTableShardingStrategyConfig();
    }

    public Optional<TableRule> findTableRule(String logicTableName) {
        return Optional.ofNullable(this.tableRules.get(logicTableName.toLowerCase()));
    }

    public Optional<TableRule> findTableRuleByActualTable(String actualTableName) {
        for (TableRule each : this.tableRules.values()) {
            if (!each.isExisted(actualTableName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (tableRule.isPresent()) {
            return tableRule.get();
        }
        if (this.isBroadcastTable(logicTableName)) {
            return new TableRule(this.dataSourceNames, logicTableName);
        }
        throw new ShardingSphereConfigurationException("Cannot find table rule with logic table: '%s'", new Object[]{logicTableName});
    }

    private TableRule getTableRule(String logicTableName, Collection<String> dataSourceNames, Map<String, TableRule> tableRules, Collection<String> broadcastTables) {
        TableRule result = tableRules.get(logicTableName);
        if (null != result) {
            return result;
        }
        if (broadcastTables.contains(logicTableName)) {
            return new TableRule(dataSourceNames, logicTableName);
        }
        throw new ShardingSphereConfigurationException("Cannot find table rule with logic table: '%s'", new Object[]{logicTableName});
    }

    public boolean isAllBindingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTableNames);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(bindingTableRule.get().getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTableNames);
    }

    public boolean isAllBindingTables(ShardingSphereDatabase database, SQLStatementContext<?> sqlStatementContext, Collection<String> logicTableNames) {
        Collection joinSegments;
        SelectStatementContext select;
        if (!(sqlStatementContext instanceof SelectStatementContext) || !((SelectStatementContext)sqlStatementContext).isContainsJoinQuery()) {
            return this.isAllBindingTables(logicTableNames);
        }
        if (!this.isAllBindingTables(logicTableNames)) {
            return false;
        }
        String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)database.getName());
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(optional -> (ShardingSphereSchema)database.getSchemas().get(optional)).orElseGet(() -> (ShardingSphereSchema)database.getSchemas().get(defaultSchemaName));
        return this.isJoinConditionContainsShardingColumns(schema, select = (SelectStatementContext)sqlStatementContext, logicTableNames, joinSegments = WhereExtractUtil.getJoinWhereSegments((SelectStatement)((SelectStatement)select.getSqlStatement()))) || this.isJoinConditionContainsShardingColumns(schema, select, logicTableNames, select.getWhereSegments());
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTableName) {
        return Optional.ofNullable(this.bindingTableRules.get(logicTableName.toLowerCase()));
    }

    public boolean isAllBroadcastTables(Collection<String> logicTableNames) {
        return !logicTableNames.isEmpty() && this.broadcastTables.containsAll(logicTableNames);
    }

    public boolean isAllShardingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        for (String each : logicTableNames) {
            if (this.isShardingTable(each)) continue;
            return false;
        }
        return true;
    }

    public boolean isShardingTable(String logicTableName) {
        return this.tableRules.containsKey(logicTableName.toLowerCase());
    }

    public boolean isBroadcastTable(String logicTableName) {
        return this.broadcastTables.contains(logicTableName);
    }

    public boolean isAllTablesInSameDataSource(Collection<String> logicTableNames) {
        Collection dataSourceNames = logicTableNames.stream().map(each -> this.tableRules.get(each.toLowerCase())).filter(Objects::nonNull).flatMap(each -> each.getActualDatasourceNames().stream()).collect(Collectors.toSet());
        return 1 == dataSourceNames.size();
    }

    public boolean tableRuleExists(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each) && !this.isBroadcastTable(each)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> findShardingColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.tableRules.get(tableName.toLowerCase())).flatMap(optional -> this.findShardingColumn((TableRule)optional, columnName));
    }

    private Optional<String> findShardingColumn(TableRule tableRule, String columnName) {
        Optional<String> databaseShardingColumn = this.findShardingColumn(this.getDatabaseShardingStrategyConfiguration(tableRule), columnName);
        if (databaseShardingColumn.isPresent()) {
            return databaseShardingColumn;
        }
        return this.findShardingColumn(this.getTableShardingStrategyConfiguration(tableRule), columnName);
    }

    private Optional<String> findShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String columnName) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            String shardingColumn = null == ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn() ? this.defaultShardingColumn : ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
            return shardingColumn.equalsIgnoreCase(columnName) ? Optional.of(shardingColumn) : Optional.empty();
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            List shardingColumns = Splitter.on((String)",").trimResults().splitToList((CharSequence)((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns());
            for (String each : shardingColumns) {
                if (!each.equalsIgnoreCase(columnName)) continue;
                return Optional.of(each);
            }
        }
        return Optional.empty();
    }

    public boolean isGenerateKeyColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.tableRules.get(tableName.toLowerCase())).filter(each -> this.isGenerateKeyColumn((TableRule)each, columnName)).isPresent();
    }

    private boolean isGenerateKeyColumn(TableRule tableRule, String columnName) {
        Optional<String> generateKeyColumn = tableRule.getGenerateKeyColumn();
        return generateKeyColumn.isPresent() && generateKeyColumn.get().equalsIgnoreCase(columnName);
    }

    public Optional<String> findGenerateKeyColumnName(String logicTableName) {
        return Optional.ofNullable(this.tableRules.get(logicTableName.toLowerCase())).filter(each -> each.getGenerateKeyColumn().isPresent()).flatMap(TableRule::getGenerateKeyColumn);
    }

    public Comparable<?> generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingSphereConfigurationException("Cannot find strategy for generate keys.", new Object[0]);
        }
        KeyGenerateAlgorithm keyGenerator = null != tableRule.get().getKeyGeneratorName() ? this.keyGenerators.get(tableRule.get().getKeyGeneratorName()) : this.defaultKeyGenerateAlgorithm;
        return keyGenerator.generateKey();
    }

    public DataNode getDataNode(String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().get(0);
    }

    public Collection<String> getShardingLogicTableNames(Collection<String> logicTableNames) {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each)) continue;
            result.add(each);
        }
        return result;
    }

    public Collection<String> getShardingRuleTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(each -> this.isShardingTable((String)each) || this.isBroadcastTable((String)each)).collect(Collectors.toList());
    }

    public Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        return this.findBindingTableRule(logicTable).map(optional -> optional.getLogicAndActualTables(dataSourceName, logicTable, actualTable, availableLogicBindingTables)).orElseGet(Collections::emptyMap);
    }

    public Collection<String> getLogicTablesByActualTable(String actualTable) {
        return this.tableRules.values().stream().filter(each -> each.isExisted(actualTable)).map(TableRule::getLogicTable).collect(Collectors.toSet());
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.shardingTableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.shardingTableDataNodes.getOrDefault(tableName.toLowerCase(), Collections.emptyList());
    }

    private Collection<String> getAllActualTables() {
        return this.tableRules.values().stream().flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toSet());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return this.findTableRule(logicTable).map(optional -> optional.getActualDataNodes().get(0).getTableName());
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return !this.isAllBroadcastTables(tables);
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return this.findTableRuleByActualTable(actualTable).map(TableRule::getLogicTable);
    }

    public Collection<String> getTables() {
        Collection result = this.tableRules.values().stream().map(TableRule::getLogicTable).collect(Collectors.toSet());
        result.addAll(this.broadcastTables);
        return result;
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return this.findTableRule(logicTable).flatMap(optional -> this.findActualTableFromActualDataNode(catalog, optional.getActualDataNodes()));
    }

    private Optional<String> findActualTableFromActualDataNode(String catalog, List<DataNode> actualDataNodes) {
        return actualDataNodes.stream().filter(each -> each.getDataSourceName().equalsIgnoreCase(catalog)).findFirst().map(DataNode::getTableName);
    }

    public String getType() {
        return ShardingRule.class.getSimpleName();
    }

    private boolean isJoinConditionContainsShardingColumns(ShardingSphereSchema schema, SelectStatementContext select, Collection<String> tableNames, Collection<WhereSegment> whereSegments) {
        HashSet<String> databaseJoinConditionTables = new HashSet<String>(tableNames.size());
        HashSet<String> tableJoinConditionTables = new HashSet<String>(tableNames.size());
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr());
            if (andPredicates.size() > 1) {
                return false;
            }
            for (AndPredicate andPredicate : andPredicates) {
                databaseJoinConditionTables.addAll(this.getJoinConditionTables(schema, select, andPredicate.getPredicates(), true));
                tableJoinConditionTables.addAll(this.getJoinConditionTables(schema, select, andPredicate.getPredicates(), false));
            }
        }
        TableRule tableRule = this.getTableRule(tableNames.iterator().next());
        boolean containsDatabaseShardingColumns = !(this.getDatabaseShardingStrategyConfiguration(tableRule) instanceof StandardShardingStrategyConfiguration) || databaseJoinConditionTables.containsAll(tableNames);
        boolean containsTableShardingColumns = !(this.getTableShardingStrategyConfiguration(tableRule) instanceof StandardShardingStrategyConfiguration) || tableJoinConditionTables.containsAll(tableNames);
        return containsDatabaseShardingColumns && containsTableShardingColumns;
    }

    private Collection<String> getJoinConditionTables(ShardingSphereSchema schema, SelectStatementContext select, Collection<ExpressionSegment> predicates, boolean isDatabaseJoinCondition) {
        LinkedList<String> result = new LinkedList<String>();
        for (ExpressionSegment each : predicates) {
            ShardingStrategyConfiguration rightConfig;
            if (!this.isJoinConditionExpression(each)) continue;
            ColumnSegment leftColumn = (ColumnSegment)((BinaryOperationExpression)each).getLeft();
            ColumnSegment rightColumn = (ColumnSegment)((BinaryOperationExpression)each).getRight();
            Map columnExpressionTableNames = select.getTablesContext().findTableNamesByColumnSegment(Arrays.asList(leftColumn, rightColumn), schema);
            Optional<TableRule> leftTableRule = this.findTableRule((String)columnExpressionTableNames.get(leftColumn.getExpression()));
            Optional<TableRule> rightTableRule = this.findTableRule((String)columnExpressionTableNames.get(rightColumn.getExpression()));
            if (!leftTableRule.isPresent() || !rightTableRule.isPresent()) continue;
            ShardingStrategyConfiguration leftConfig = isDatabaseJoinCondition ? this.getDatabaseShardingStrategyConfiguration(leftTableRule.get()) : this.getTableShardingStrategyConfiguration(leftTableRule.get());
            ShardingStrategyConfiguration shardingStrategyConfiguration = rightConfig = isDatabaseJoinCondition ? this.getDatabaseShardingStrategyConfiguration(rightTableRule.get()) : this.getTableShardingStrategyConfiguration(rightTableRule.get());
            if (!this.findShardingColumn(leftConfig, leftColumn.getIdentifier().getValue()).isPresent() || !this.findShardingColumn(rightConfig, rightColumn.getIdentifier().getValue()).isPresent()) continue;
            result.add((String)columnExpressionTableNames.get(leftColumn.getExpression()));
            result.add((String)columnExpressionTableNames.get(rightColumn.getExpression()));
        }
        return result;
    }

    private boolean isJoinConditionExpression(ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            return false;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        return binaryExpression.getLeft() instanceof ColumnSegment && binaryExpression.getRight() instanceof ColumnSegment && EQUAL.equals(binaryExpression.getOperator());
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        this.keyGenerators.values().stream().filter(each -> each instanceof InstanceAwareAlgorithm).forEach(each -> ((InstanceAwareAlgorithm)each).setInstanceContext(instanceContext));
        if (this.defaultKeyGenerateAlgorithm instanceof InstanceAwareAlgorithm) {
            ((InstanceAwareAlgorithm)this.defaultKeyGenerateAlgorithm).setInstanceContext(instanceContext);
        }
    }

    private Map<String, ShardingAlgorithm> createShardingAlgorithms(Map<String, ShardingSphereAlgorithmConfiguration> shardingAlgorithms, Collection<ShardingTableRuleConfiguration> tables, Collection<ShardingAutoTableRuleConfiguration> autoTables) {
        Map<String, String> algorithmReplaceTablePrefixMap = this.getAlgorithmReplaceTablePrefixMap(tables, autoTables);
        LinkedHashMap<String, ShardingAlgorithm> result = new LinkedHashMap<String, ShardingAlgorithm>(shardingAlgorithms.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry : shardingAlgorithms.entrySet()) {
            result.put(entry.getKey(), this.createShardingAlgorithm(entry.getKey(), entry.getValue(), algorithmReplaceTablePrefixMap));
        }
        return result;
    }

    private ShardingAlgorithm createShardingAlgorithm(String name, ShardingSphereAlgorithmConfiguration config, Map<String, String> algorithmReplaceTablePrefixMap) {
        if (algorithmReplaceTablePrefixMap.containsKey(name)) {
            String algorithmExpression = config.getProps().getProperty(ALGORITHM_EXPRESSION_KEY);
            String replaceTablePrefix = algorithmReplaceTablePrefixMap.get(name);
            if (!Strings.isNullOrEmpty((String)algorithmExpression) && !algorithmExpression.startsWith(replaceTablePrefix)) {
                config.getProps().setProperty(ALGORITHM_EXPRESSION_KEY, replaceTablePrefix + algorithmExpression);
            }
        }
        return ShardingAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)config);
    }

    private Map<String, String> getAlgorithmReplaceTablePrefixMap(Collection<ShardingTableRuleConfiguration> tables, Collection<ShardingAutoTableRuleConfiguration> autoTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(tables.size() + autoTables.size(), 1.0f);
        for (ShardingTableRuleConfiguration shardingTableRuleConfiguration : tables) {
            if (null == shardingTableRuleConfiguration.getReplaceTablePrefix() || null == shardingTableRuleConfiguration.getTableShardingStrategy()) continue;
            result.put(shardingTableRuleConfiguration.getTableShardingStrategy().getShardingAlgorithmName(), shardingTableRuleConfiguration.getReplaceTablePrefix());
        }
        for (ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfiguration : autoTables) {
            if (null == shardingAutoTableRuleConfiguration.getReplaceTablePrefix() || null == shardingAutoTableRuleConfiguration.getShardingStrategy()) continue;
            result.put(shardingAutoTableRuleConfiguration.getShardingStrategy().getShardingAlgorithmName(), shardingAutoTableRuleConfiguration.getReplaceTablePrefix());
        }
        return result;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, ShardingAlgorithm> getShardingAlgorithms() {
        return this.shardingAlgorithms;
    }

    @Generated
    public Map<String, KeyGenerateAlgorithm> getKeyGenerators() {
        return this.keyGenerators;
    }

    @Generated
    public Map<String, TableRule> getTableRules() {
        return this.tableRules;
    }

    @Generated
    public Map<String, BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    @Generated
    public Collection<String> getBroadcastTables() {
        return this.broadcastTables;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultDatabaseShardingStrategyConfig() {
        return this.defaultDatabaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultTableShardingStrategyConfig() {
        return this.defaultTableShardingStrategyConfig;
    }

    @Generated
    public KeyGenerateAlgorithm getDefaultKeyGenerateAlgorithm() {
        return this.defaultKeyGenerateAlgorithm;
    }

    @Generated
    public String getDefaultShardingColumn() {
        return this.defaultShardingColumn;
    }

    @Generated
    public Map<String, Collection<DataNode>> getShardingTableDataNodes() {
        return this.shardingTableDataNodes;
    }
}

