/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.validator.dml.ShardingDMLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class ShardingInsertStatementValidator
extends ShardingDMLStatementValidator<InsertStatement> {
    private final ShardingConditions shardingConditions;

    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<InsertStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        if (null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            this.validateMultipleTable(shardingRule, sqlStatementContext);
        }
        String tableName = ((InsertStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Optional insertSelectSegment = ((InsertStatement)sqlStatementContext.getSqlStatement()).getInsertSelect();
        if (insertSelectSegment.isPresent() && this.isContainsKeyGenerateStrategy(shardingRule, tableName) && !this.isContainsKeyGenerateColumn(shardingRule, ((InsertStatement)sqlStatementContext.getSqlStatement()).getColumns(), tableName)) {
            throw new ShardingSphereException("INSERT INTO ... SELECT can not support applying keyGenerator to absent generateKeyColumn.", new Object[0]);
        }
        TablesContext tablesContext = sqlStatementContext.getTablesContext();
        if (insertSelectSegment.isPresent() && shardingRule.tableRuleExists(tablesContext.getTableNames()) && !this.isAllSameTables(tablesContext.getTableNames()) && !shardingRule.isAllBindingTables(tablesContext.getTableNames())) {
            throw new ShardingSphereException("The table inserted and the table selected must be the same or bind tables.", new Object[0]);
        }
    }

    private boolean isContainsKeyGenerateStrategy(ShardingRule shardingRule, String tableName) {
        return shardingRule.findGenerateKeyColumnName(tableName).isPresent();
    }

    private boolean isContainsKeyGenerateColumn(ShardingRule shardingRule, Collection<ColumnSegment> columns, String tableName) {
        return columns.isEmpty() || columns.stream().anyMatch(each -> shardingRule.isGenerateKeyColumn(each.getIdentifier().getValue(), tableName));
    }

    private boolean isAllSameTables(Collection<String> tableNames) {
        return 1L == tableNames.stream().distinct().count();
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<InsertStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        Optional insertSelect = ((InsertStatement)sqlStatementContext.getSqlStatement()).getInsertSelect();
        if (insertSelect.isPresent() && this.shardingConditions.isNeedMerge()) {
            boolean singleRoutingOrSameShardingCondition = routeContext.isSingleRouting() || this.shardingConditions.isSameShardingCondition();
            Preconditions.checkState((boolean)singleRoutingOrSameShardingCondition, (Object)"Subquery sharding conditions must be same with primary query.");
        }
        String tableName = ((InsertStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Collection assignments = InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatement)sqlStatementContext.getSqlStatement())).map(OnDuplicateKeyColumnsSegment::getColumns).orElse(Collections.emptyList());
        Optional<ShardingConditions> onDuplicateKeyShardingConditions = this.createShardingConditions(sqlStatementContext, shardingRule, assignments, parameters);
        Optional<RouteContext> onDuplicateKeyRouteContext = onDuplicateKeyShardingConditions.map(optional -> new ShardingStandardRoutingEngine(tableName, (ShardingConditions)optional, props).route(shardingRule));
        if (onDuplicateKeyRouteContext.isPresent() && !this.isSameRouteContext(routeContext, onDuplicateKeyRouteContext.get())) {
            throw new ShardingSphereException("Can not update sharding key since the updated value will change %s's data nodes.", new Object[]{tableName});
        }
        if (!routeContext.isSingleRouting() && !shardingRule.isBroadcastTable(tableName)) {
            boolean isSingleDataNode = routeContext.getOriginalDataNodes().stream().allMatch(dataNodes -> dataNodes.size() == 1);
            Preconditions.checkState((boolean)isSingleDataNode, (Object)"Insert statement does not support sharding table routing to multiple data nodes.");
        }
    }

    @Generated
    public ShardingInsertStatementValidator(ShardingConditions shardingConditions) {
        this.shardingConditions = shardingConditions;
    }
}

