/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropTableStatementHandler;

public final class ShardingDropTableStatementValidator
extends ShardingDDLStatementValidator<DropTableStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<DropTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        if (!DropTableStatementHandler.containsExistClause((DropTableStatement)((DropTableStatement)sqlStatementContext.getSqlStatement()))) {
            String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)database.getName());
            ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(optional -> (ShardingSphereSchema)database.getSchemas().get(optional)).orElseGet(() -> (ShardingSphereSchema)database.getSchemas().get(defaultSchemaName));
            this.validateTableExist(schema, sqlStatementContext.getTablesContext().getTables());
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<DropTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        this.checkTableInUsed(shardingRule, (DropTableStatement)sqlStatementContext.getSqlStatement(), routeContext);
        for (SimpleTableSegment each : ((DropTableStatement)sqlStatementContext.getSqlStatement()).getTables()) {
            if (!this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, each.getTableName().getIdentifier().getValue())) continue;
            throw new ShardingSphereException("DROP TABLE ... statement can not route correctly for tables %s.", new Object[]{sqlStatementContext.getTablesContext().getTableNames()});
        }
    }

    private void checkTableInUsed(ShardingRule shardingRule, DropTableStatement sqlStatement, RouteContext routeContext) {
        LinkedList<String> inUsedTable = new LinkedList<String>();
        Set dropTables = sqlStatement.getTables().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toSet());
        Set actualTables = routeContext.getRouteUnits().stream().flatMap(each -> each.getTableMappers().stream().map(RouteMapper::getActualName)).collect(Collectors.toSet());
        Collection tableMeta = shardingRule.getTableRules().values().stream().filter(each -> !dropTables.contains(each.getLogicTable())).flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toSet());
        for (String each2 : actualTables) {
            if (!tableMeta.contains(each2)) continue;
            inUsedTable.add(each2);
        }
        if (!inUsedTable.isEmpty()) {
            throw new ShardingSphereException("Actual Tables: [%s] are in use.", new Object[]{inUsedTable});
        }
    }
}

